/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.internal.config.generator;

import java.util.Hashtable;

public class HashUtility {
	//
	// Check if a parameter exist
	//
	public static boolean exist(Hashtable hash, String tag) {
		return hash.containsKey(tag);
	}

	//
	// Return the value specified by the parameter
	//
	public static String getValue(Hashtable hash, String tag) {
		if (hash.containsKey(tag)) {
			return (String) hash.get(tag);
		} else {
			return null;
		}
	}

	//
	// Set the value specified by the parameter
	//
	public static void setValue(Hashtable hash, String tag, String value) {
		hash.put(tag, value);
	}

	public static void removeKey(Hashtable hash, String tag) {
		hash.remove(tag);
	}

}
