/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
/**
 * This exception contains a list of exceptions.
 */
public class DBCollectedExceptions extends RuntimeException {
	/**
	 * Constructor for DBCollectedExceptions.
	 */
	protected List exceptions;
	public DBCollectedExceptions(List exceptions) {
		super(getCollectedMessage(exceptions));
		this.exceptions = exceptions;
	}
	/**
	 * @param exceptions2
	 * @return
	 */
	public static String getCollectedMessage(List l) {
		String res="";
		for (Iterator iter = l.iterator(); iter.hasNext();) {
			Exception element = (Exception) iter.next();
			res=res+element.getLocalizedMessage()+"\n";
		}
		return res;
	}
	public DBCollectedExceptions(Throwable exception) {
		super(exception.getLocalizedMessage());
		this.exceptions = new ArrayList();
		this.exceptions.add(exception);
	}
	public DBCollectedExceptions() {
		super("Collected exceptions:");
	}
	/**
	 * @return Returns the exceptions.
	 */
	public List getExceptions() {
		if (exceptions == null)
			return exceptions = new ArrayList();
		return exceptions;
	}
	public void printStackTrace() {
		printStackTrace1(System.err);
	}
	public void printStackTrace(java.io.PrintStream s) {
		printStackTrace1(s);
	}
	public void printStackTrace(java.io.PrintWriter s) {
		printStackTrace1(s);
	}
	public void printStackTrace1(Object s) {
		for (Iterator iter = getExceptions().iterator(); iter.hasNext();) {
			Exception element = (Exception) iter.next();
			if (s instanceof PrintStream)
				element.printStackTrace((PrintStream) s);
			else if (s instanceof PrintWriter)
				element.printStackTrace((PrintWriter) s);
		}
	}
}