/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel;

import org.eclipse.emf.common.util.EList;
/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Column</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#isAllowNull <em>Allow Null</em>}</li>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#getTable <em>Table</em>}</li>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#getConstraints <em>Constraints</em>}</li>
 *   <li>{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#getColumn()
 * @model
 * @generated
 */
public interface Column extends DBElement {
	/**

	 * Returns the value of the '<em><b>Allow Null</b></em>' attribute.

	 * <!-- begin-user-doc -->

	 * <p>

	 * If the meaning of the '<em>Allow Null</em>' attribute isn't clear,

	 * there really should be more of a description here...

	 * </p>

	 * <!-- end-user-doc -->

	 * @return the value of the '<em>Allow Null</em>' attribute.

	 * @see #setAllowNull(boolean)

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#getColumn_AllowNull()

	 * @model 

	 * @generated

	 */

	boolean isAllowNull();

	/**

	 * Sets the value of the '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#isAllowNull <em>Allow Null</em>}' attribute.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @param value the new value of the '<em>Allow Null</em>' attribute.

	 * @see #isAllowNull()

	 * @generated

	 */

	void setAllowNull(boolean value);

	/**

	 * Returns the value of the '<em><b>Table</b></em>' container reference.

	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Table#getColumns <em>Columns</em>}'.

	 * <!-- begin-user-doc -->

	 * <p>

	 * If the meaning of the '<em>Table</em>' container reference isn't clear,

	 * there really should be more of a description here...

	 * </p>

	 * <!-- end-user-doc -->

	 * @return the value of the '<em>Table</em>' container reference.

	 * @see #setTable(Table)

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#getColumn_Table()

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Table#getColumns

	 * @model opposite="columns"

	 * @generated

	 */

	Table getTable();

	/**

	 * Sets the value of the '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#getTable <em>Table</em>}' container reference.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @param value the new value of the '<em>Table</em>' container reference.

	 * @see #getTable()

	 * @generated

	 */

	void setTable(Table value);

	/**

	 * Returns the value of the '<em><b>Constraints</b></em>' reference list.

	 * The list contents are of type {@link org.eclipse.hyades.resources.database.internal.dbmodel.Constraint}.

	 * It is bidirectional and its opposite is '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Constraint#getColumns <em>Columns</em>}'.

	 * <!-- begin-user-doc -->

	 * <p>

	 * If the meaning of the '<em>Constraints</em>' reference list isn't clear,

	 * there really should be more of a description here...

	 * </p>

	 * <!-- end-user-doc -->

	 * @return the value of the '<em>Constraints</em>' reference list.

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#getColumn_Constraints()

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.Constraint#getColumns

	 * @model type="org.eclipse.hyades.resources.database.internal.dbmodel.Constraint" opposite="columns"

	 * @generated

	 */

	EList getConstraints();

	/**

	 * Returns the value of the '<em><b>Type</b></em>' reference.

	 * <!-- begin-user-doc -->

	 * <p>

	 * If the meaning of the '<em>Type</em>' reference isn't clear,

	 * there really should be more of a description here...

	 * </p>

	 * <!-- end-user-doc -->

	 * @return the value of the '<em>Type</em>' reference.

	 * @see #setType(SQLType)

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#getColumn_Type()

	 * @model 

	 * @generated

	 */

	SQLType getType();

	/**

	 * Sets the value of the '{@link org.eclipse.hyades.resources.database.internal.dbmodel.Column#getType <em>Type</em>}' reference.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @param value the new value of the '<em>Type</em>' reference.

	 * @see #getType()

	 * @generated

	 */

	void setType(SQLType value);

	Object getDefaultValue();
	void setDefaultValue(Object newValue);
} // Column

