/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.dbmodel.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.hyades.resources.database.internal.dbmodel.Column;
import org.eclipse.hyades.resources.database.internal.dbmodel.Constraint;
import org.eclipse.hyades.resources.database.internal.dbmodel.DBElement;
import org.eclipse.hyades.resources.database.internal.dbmodel.Database;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelFactory;
import org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage;
import org.eclipse.hyades.resources.database.internal.dbmodel.SQLType;
import org.eclipse.hyades.resources.database.internal.dbmodel.StringType;
import org.eclipse.hyades.resources.database.internal.dbmodel.Table;
/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class DbmodelPackageImpl extends EPackageImpl implements DbmodelPackage {
	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	private EClass dbElementEClass = null;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	private EClass databaseEClass = null;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	private EClass tableEClass = null;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	private EClass columnEClass = null;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	private EClass sqlTypeEClass = null;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	private EClass constraintEClass = null;

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	private EClass stringTypeEClass = null;

	/**

	 * Creates an instance of the model <b>Package</b>, registered with

	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package

	 * package URI value.

	 * <p>Note: the correct way to create the package is via the static

	 * factory method {@link #init init()}, which also performs

	 * initialization of the package, or returns the registered package,

	 * if one already exists.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see org.eclipse.emf.ecore.EPackage.Registry

	 * @see org.eclipse.hyades.resources.database.internal.dbmodel.DbmodelPackage#eNS_URI

	 * @see #init()

	 * @generated

	 */

	private DbmodelPackageImpl() {
		super(eNS_URI, DbmodelFactory.eINSTANCE);

	}

	/**

	 * Creates, registers, and initializes the <b>Package</b> for this

	 * model, and for any others upon which it depends.  Simple

	 * dependencies are satisfied by calling this method on all

	 * dependent packages before doing anything else.  This method drives

	 * initialization for interdependent packages directly, in parallel

	 * with this package, itself.

	 * <p>Of this package and its interdependencies, all packages which

	 * have not yet been registered by their URI values are first created

	 * and registered.  The packages are then initialized in two steps:

	 * meta-model objects for all of the packages are created before any

	 * are initialized, since one package's meta-model objects may refer to

	 * those of another.

	 * <p>Invocation of this method will not affect any packages that have

	 * already been initialized.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @see #eNS_URI

	 * @see #createPackageContents()

	 * @see #initializePackageContents()

	 * @generated

	 */

	public static DbmodelPackage init() {
		// Obtain or create and register package and interdependencies

		DbmodelPackageImpl theDbmodelPackage = (DbmodelPackageImpl) (EPackage.Registry.INSTANCE.get(eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(eNS_URI) : new DbmodelPackageImpl());

		// Step 1: create meta-model objects

		theDbmodelPackage.createPackageContents();

		// Step 2: complete initialization

		theDbmodelPackage.initializePackageContents();

		return theDbmodelPackage;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EClass getDBElement() {
		return dbElementEClass;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EAttribute getDBElement_Name() {
		return (EAttribute) dbElementEClass.getEAttributes().get(0);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EClass getDatabase() {
		return databaseEClass;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EReference getDatabase_Tables() {
		return (EReference) databaseEClass.getEReferences().get(0);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EReference getDatabase_Types() {
		return (EReference) databaseEClass.getEReferences().get(1);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EClass getTable() {
		return tableEClass;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EReference getTable_Constraints() {
		return (EReference) tableEClass.getEReferences().get(0);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EReference getTable_Columns() {
		return (EReference) tableEClass.getEReferences().get(1);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EClass getColumn() {
		return columnEClass;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EAttribute getColumn_AllowNull() {
		return (EAttribute) columnEClass.getEAttributes().get(0);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EReference getColumn_Table() {
		return (EReference) columnEClass.getEReferences().get(0);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EReference getColumn_Constraints() {
		return (EReference) columnEClass.getEReferences().get(1);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EReference getColumn_Type() {
		return (EReference) columnEClass.getEReferences().get(2);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EClass getSQLType() {
		return sqlTypeEClass;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EAttribute getSQLType_SqlType() {
		return (EAttribute) sqlTypeEClass.getEAttributes().get(0);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EClass getConstraint() {
		return constraintEClass;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EAttribute getConstraint_Type() {
		return (EAttribute) constraintEClass.getEAttributes().get(0);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EReference getConstraint_Columns() {
		return (EReference) constraintEClass.getEReferences().get(0);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EClass getStringType() {
		return stringTypeEClass;

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public EAttribute getStringType_Length() {
		return (EAttribute) stringTypeEClass.getEAttributes().get(0);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public DbmodelFactory getDbmodelFactory() {
		return (DbmodelFactory) getEFactoryInstance();

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	private boolean isCreated = false;

	/**

	 * Creates the meta-model objects for the package.  This method is

	 * guarded to have no affect on any invocation but its first.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void createPackageContents() {
		if (isCreated)
			return;

		isCreated = true;

		// Create classes and their features

		dbElementEClass = createEClass(DB_ELEMENT);

		createEAttribute(dbElementEClass, DB_ELEMENT__NAME);

		databaseEClass = createEClass(DATABASE);

		createEReference(databaseEClass, DATABASE__TABLES);

		createEReference(databaseEClass, DATABASE__TYPES);

		tableEClass = createEClass(TABLE);

		createEReference(tableEClass, TABLE__CONSTRAINTS);

		createEReference(tableEClass, TABLE__COLUMNS);

		columnEClass = createEClass(COLUMN);

		createEAttribute(columnEClass, COLUMN__ALLOW_NULL);

		createEReference(columnEClass, COLUMN__TABLE);

		createEReference(columnEClass, COLUMN__CONSTRAINTS);

		createEReference(columnEClass, COLUMN__TYPE);

		sqlTypeEClass = createEClass(SQL_TYPE);

		createEAttribute(sqlTypeEClass, SQL_TYPE__SQL_TYPE);

		constraintEClass = createEClass(CONSTRAINT);

		createEAttribute(constraintEClass, CONSTRAINT__TYPE);

		createEReference(constraintEClass, CONSTRAINT__COLUMNS);

		stringTypeEClass = createEClass(STRING_TYPE);

		createEAttribute(stringTypeEClass, STRING_TYPE__LENGTH);

	}

	/**

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	private boolean isInitialized = false;

	/**

	 * Complete the initialization of the package and its meta-model.  This

	 * method is guarded to have no affect on any invocation but its first.

	 * <!-- begin-user-doc -->

	 * <!-- end-user-doc -->

	 * @generated

	 */

	public void initializePackageContents() {
		if (isInitialized)
			return;

		isInitialized = true;

		// Initialize package

		setName(eNAME);

		setNsPrefix(eNS_PREFIX);

		setNsURI(eNS_URI);

		// Add supertypes to classes

		databaseEClass.getESuperTypes().add(this.getDBElement());

		tableEClass.getESuperTypes().add(this.getDBElement());

		columnEClass.getESuperTypes().add(this.getDBElement());

		sqlTypeEClass.getESuperTypes().add(this.getDBElement());

		constraintEClass.getESuperTypes().add(this.getDBElement());

		stringTypeEClass.getESuperTypes().add(this.getSQLType());

		// Initialize classes and features; add operations and parameters

		initEClass(dbElementEClass, DBElement.class, "DBElement", !IS_ABSTRACT, !IS_INTERFACE);

		initEAttribute(getDBElement_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID);

		initEClass(databaseEClass, Database.class, "Database", !IS_ABSTRACT, !IS_INTERFACE);

		initEReference(getDatabase_Tables(), this.getTable(), null, "tables", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE);

		initEReference(getDatabase_Types(), this.getSQLType(), null, "types", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE);

		initEClass(tableEClass, Table.class, "Table", !IS_ABSTRACT, !IS_INTERFACE);

		initEReference(getTable_Constraints(), this.getConstraint(), null, "constraints", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE);

		initEReference(getTable_Columns(), this.getColumn(), this.getColumn_Table(), "columns", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE);

		initEClass(columnEClass, Column.class, "Column", !IS_ABSTRACT, !IS_INTERFACE);

		initEAttribute(getColumn_AllowNull(), ecorePackage.getEBoolean(), "allowNull", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID);

		initEReference(getColumn_Table(), this.getTable(), this.getTable_Columns(), "Table", null, 0, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE);

		initEReference(getColumn_Constraints(), this.getConstraint(), this.getConstraint_Columns(), "constraints", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE);

		initEReference(getColumn_Type(), this.getSQLType(), null, "type", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE);

		initEClass(sqlTypeEClass, SQLType.class, "SQLType", !IS_ABSTRACT, !IS_INTERFACE);

		initEAttribute(getSQLType_SqlType(), ecorePackage.getEInt(), "sqlType", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID);

		initEClass(constraintEClass, Constraint.class, "Constraint", !IS_ABSTRACT, !IS_INTERFACE);

		initEAttribute(getConstraint_Type(), ecorePackage.getEString(), "type", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID);

		initEReference(getConstraint_Columns(), this.getColumn(), this.getColumn_Constraints(), "columns", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE);

		initEClass(stringTypeEClass, StringType.class, "StringType", !IS_ABSTRACT, !IS_INTERFACE);

		initEAttribute(getStringType_Length(), ecorePackage.getEInt(), "maxSQLLength", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID);

		// Create resource

		createResource(eNS_URI);

	}

} //DbmodelPackageImpl

