/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DBCommandFactory;
import org.eclipse.hyades.resources.database.internal.extensions.JDBCHelper;
/**
 * This class counts the number of referenced objects for the object with the
 * given id and reference.
 */
public class GetIdByURICommand extends DBCommand {
	protected String uri;

	protected EClass currentSourceType;
	protected int currentSourceId;
	protected EReference currentTargetReference;
	protected int currentTargetIndex;
	protected int currentFragmentIndex;
	protected String fragment;

	public GetIdByURICommand(JDBCHelper helper, DBMap map, String uri) {
		super(helper, map);
		this.uri = uri;
	}

	/**
	 * Return an array of EObjects, or null.
	 */
	public Object execute() throws Exception {
		currentFragmentIndex=0;
		getRootObjectId();
		if(currentTargetReference!=null)
		{
			do {
				StatementFactory factory = StatementFactory.INSTANCE;
				QueryStatement query = factory.createGetTargetIdStatement(helper, dbMap, currentSourceId, currentTargetReference, currentTargetIndex);
				Statement statement = helper.createStatement();
				ResultSet rs = helper.executeQuery(statement, query.getStatement());
	
				while (rs.next())
					currentSourceId = rs.getInt(1);
				rs.close();
				statement.close();
	
			} while (processNextObject());
		}

		return new Integer(currentSourceId);
	}

	/**
	 * @return the first root object dbId
	 */
	protected void getRootObjectId() throws Exception {
		int i = uri.indexOf('#');
		if(i!=-1)
			uri=uri.substring(0,i);
		URI r = URI.createURI(uri);
		fragment = r.fragment();

		DBCommand c = DBCommandFactory.INSTANCE.createGetTopLevelObjects(helper, dbMap, r);
		List l = (List) c.execute();
		if (l.size() > 1) {
			currentSourceId = ((Integer)((ArrayList) l.get(1)).get(0)).intValue();
			currentSourceType = (EClass) l.get(0);
			if (fragment!=null && fragment.startsWith("//")) {
				currentFragmentIndex = 2;
				processNextObject();
			} else {
				// TODO MS handle the case for multiple root objects
			}
		}
	}

	/**
	 * @return true if has remaining objects
	 */
	protected boolean processNextObject() {
		if (currentFragmentIndex >= fragment.length() - 1)
			return false;
		currentFragmentIndex = fragment.indexOf('/', currentFragmentIndex);
		int fEndIndex;
		int dotIndex = fragment.indexOf('.', currentFragmentIndex);
		if (dotIndex == -1) {
			fEndIndex = fragment.indexOf('/', currentFragmentIndex);
		} else
			fEndIndex = dotIndex;

		if (fEndIndex == -1) {
			fEndIndex = fragment.length() - 1;
		}
		String fName = fragment.substring(currentFragmentIndex, fEndIndex);
		currentTargetReference = (EReference) currentSourceType.getEStructuralFeature(fName);
		currentSourceType = (EClass)currentTargetReference.getEType();
		if (dotIndex == -1) {
			currentFragmentIndex = fEndIndex;
			currentTargetIndex = 0;
		} else {
			currentFragmentIndex = fragment.indexOf('/', dotIndex + 1);
			if (currentFragmentIndex == -1)
				currentFragmentIndex = fragment.length() - 1;
			currentTargetIndex = Integer.parseInt(fragment.substring(dotIndex + 1, currentFragmentIndex));
			currentFragmentIndex++;
		}
		return true;
	}
} // GetCommpressedPathByURICommand
