/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.resources.database.internal.DBMap;
import org.eclipse.hyades.resources.database.internal.extensions.DatabaseType;
/**
 * This statement gets referenced objects for a set of given object ids. It
 * orders them if there is an order column for the given reference and the order
 * flag is true.
 */
public class GreedyReferenceQueryStatement extends QueryStatement {
	protected int[] ids;
	protected String source, target, order;
	protected boolean orderFlag;

	public GreedyReferenceQueryStatement(int[] ids, EReference reference, DBMap map, DatabaseType dbType, boolean orderFlag) {
		super(dbType, map, reference);
		this.ids = ids;
		DBMap.ReferenceData data = (DBMap.ReferenceData) dbMap.getDBRepresentation(reference);
		source = data.getSourceColumn().getName();
		target = data.getTargetColumn().getName();

		if (data.getOrderColumn() != null)
			order = data.getOrderColumn().getName();

		initial = 0;
		this.orderFlag = orderFlag;
	}

	protected void createSelectFrom() {
		statement.append("SELECT ");

		statement.append(addQuotes(source));
		statement.append(", ");
		statement.append(addQuotes(target));

		if (orderFlag && order != null && dbType.isOrderRequired()) {
			statement.append(", ");
			statement.append(addQuotes(order));
		}

		statement.append(" FROM ");
		statement.append(addQuotes(table.getName()));
	}

	protected void createWhereClause(int begin) {
		statement.append(" WHERE ");
		statement.append(addQuotes(source));
		statement.append(" IN (");

		for (int i = begin; i < ids.length; i++) {
			String id = "" + ids[i];

			if (statement.length() + id.length() > dbType.getMaximumSQLLength()) {
				initial = i;
				break;
			}

			if (i != begin)
				statement.append(", ");

			statement.append(ids[i]);
		}

		statement.append(")");
	}

	protected void createOrderClause() {
		if (orderFlag && order != null) {
			statement.append(" ORDER BY ");
			statement.append(addQuotes(source));
			statement.append(", ");
			statement.append(addQuotes(order));
		}
	}
} // GreedyReferenceQueryStatement
