/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.resources.database.internal.impl;

import org.eclipse.hyades.resources.database.internal.ObjectQuery;
import org.eclipse.hyades.resources.database.internal.QueryFactory;
import org.eclipse.hyades.resources.database.internal.ReferenceQuery;
/**
 * This class implements the QueryFactory interface.
 */
public class QueryFactoryImpl implements QueryFactory {
	/**
	 * Constructor for QueryFactoryImpl.
	 */
	public QueryFactoryImpl() {
		super();
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.QueryFactory#createObjectQuery()
	 */
	public ObjectQuery createObjectQuery() {
		return new ObjectQueryImpl();
	}

	/**
	 * @see org.eclipse.hyades.resources.database.internal.QueryFactory#createReferenceQuery()
	 */
	public ReferenceQuery createReferenceQuery() {
		return new ReferenceQueryImpl();
	}
} // QueryFactoryImpl
