/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.internal.execution.file;

import org.eclipse.hyades.execution.security.IConnectionHandler;

/**
 * @author Giridhar.S
 * 
 * This is the interface to be implemented by classes which want to pass 
 * parameters to the file server.
 *
 */
public interface IFileServerParameters {
	
	/**
	 * Method to load the file server with the FileConnectionHandler which creates client handlers
	 * for each client request.
	 * 
	 * @return new ConnectionHandler.
	 */
	public IConnectionHandler getConnectionHandler();
	
	/**
	 * Method to set the file server port number.
	 * @param port
	 */
	public void setPort(int port);
	
	/**
	 * @return file server port number configured in Agent Controller.
	 */
	public int getPort();
}