/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

class RABinaryArray implements Constants {

	protected byte[] _data;
	protected int _padding=0;

public RABinaryArray() {
	super();
}

public RABinaryArray(byte[] data) {
	if(data!=null) {
		_data=data;
		calculatePadding();
	}
	else {
		_padding=0;
	}
}

private void calculatePadding() {
	_padding=4-_data.length%4;
	if(_padding==4) {
		_padding=0;
	}	
}

public byte[] getData() {
	return _data;
}

public int getPadding() {
	return _padding;
}

public int getSize() {
	return sizeofLong+_data.length+_padding;
}

public long length() {
	if(_data!=null)
		return _data.length;

	return 0;
}

public void setData(byte[] data) {
	_data=data;
	calculatePadding();
}

public void setData(byte[] data, int offset, int length) {
	if(data!=null) {
		_data=new byte[length];
		System.arraycopy(data, offset, _data, 0, length);
		calculatePadding();
	}
}

}