/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.wizard.*;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.wizard.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.actions.*;
import org.eclipse.ui.*;

/*
* CONTEXT_ID owiz0000 for new wizard action
*/

public class OpenWizardAction extends SelectionProviderAction
{
  private Class fWizardClass;
  private INavigator fViewer;
  
  public OpenWizardAction(INavigator viewer,
						  Class wizardclass,
						  String label)
  {
	super(viewer.getViewer(), label);
	fWizardClass = wizardclass;
	fViewer = viewer;

  }  
  public void run()
  {
	try
	{
	  IWorkbench workbench = UIPlugin.getDefault().getWorkbench();	  
		
	  Wizard wizard = (Wizard) fWizardClass.newInstance();
	  WizardDialog dialog = new WizardDialog(fViewer.getViewSite().getShell(), wizard);

	  IStructuredSelection selection = (IStructuredSelection) fViewer.getViewer().getSelection();
	  if (wizard instanceof INewWizard)
	  {
		((INewWizard) wizard).init(workbench, selection);
	  }
	  if (wizard instanceof NewMonitorWizard)
		((NewMonitorWizard) wizard).setViewer((PDProjectExplorer)fViewer);		
	  else if (wizard instanceof NewNodeWizard)
		((NewNodeWizard) wizard).setViewer(fViewer);
	  else if (wizard instanceof OpenProcessWizard)
		((OpenProcessWizard) wizard).setViewer((PDProjectExplorer)fViewer);		
	  else if (wizard instanceof OpenLogAgentWizard)
		((OpenLogAgentWizard) wizard).setViewer(fViewer);
		else if (wizard instanceof OpenProfAgentWizard)
		  ((OpenProfAgentWizard) wizard).setViewer((PDProjectExplorer)fViewer);

	  dialog.open();

	}
	catch (IllegalAccessException e)
	{ 
	  e.printStackTrace();
	}
	catch (InstantiationException e)
	{
	  e.printStackTrace();
	}
  } 
  
  public void dispose() {
		
	  super.dispose();
		
	  fViewer = null;
	  fWizardClass = null;
  }

}
