/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.MessageDialog;

/*
* CONTEXT_ID sttr0000 for stop monitor(trace) action
*/

public class StopTraceActionDelegate extends AbstractListenerActionDelegate {

	/**
	 * @see AbstractProfileActionDelegate#doAction(Object)
	 */
	public void doAction(Object object) throws Exception {

		if (object == null || !(object instanceof TRCAgentProxy))
			return;

		//PDProjectExplorer fViewer = UIPlugin.getDefault().getViewer();
		INavigator fViewer = (INavigator)getView();
		if (fViewer == null) {
			MessageDialog.openInformation(
				UIPlugin.getActiveWorkbenchShell(),
				"title",
				"Action not available in current context");
			return;
		}

		run((TRCAgentProxy) object, fViewer);
	}

	public void run(TRCAgentProxy agent, INavigator fViewer) {

		TRCProcessProxy process = agent.getProcessProxy();
		String host = process.getNode().getName();

		try {
			Node node = PDCoreUtil.profileConnect(host, String.valueOf(process.getNode().getPort()));
			if (node == null) {
					return;
			}

			Object instance = LoadersUtils.locateAgentInstance(agent);
			if(instance != null && instance instanceof Agent)
			{
				Agent a = (Agent)instance;
				if (a.isMonitored()) {
					a.stopMonitoring();

					agent.setMonitored(false);
					agent.setAttached(true);
					agent.setActive(true);
					
					ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
					event.setSource(agent);
					event.setType(ProfileEvent.STOP_MONITOR);
					
					UIPlugin.getDefault().notifyProfileEventListener(event);					
				}
			}

			//update ui
			fViewer.getViewer().refresh(agent);

		}catch (Exception exc) {
			exc.printStackTrace();
		}
	}

	/**
	 * @see AbstractProfileActionDelegate#isEnabledFor(Object)
	 */
	protected boolean isEnabledFor(Object element) {

		if (element != null
			&& (element instanceof TRCAgentProxy)
			&& ((TRCAgentProxy) element).isMonitored())
		{
			getAction().setEnabled(true);
			return true;
		}
		
		getAction().setEnabled(false);						
		return false;

	}
	public void dispose()
	{
		super.dispose();
	}

}
