/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import java.util.ArrayList;

import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.sourcelookup.SourceLookupTab;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jdt.debug.ui.launchConfigurations.AppletArgumentsTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.AppletMainTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.AppletParametersTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jface.preference.IPreferenceStore;

public class ProfileJavaAppletTabGroup extends AbstractLaunchConfigurationTabGroup
{
	public void createTabs(ILaunchConfigurationDialog dialog, String mode)
	{
		// check preferences whether profiling is enabled
		IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
		boolean isProfilingEnabled = store.getBoolean(TraceConstants.PROF_OPTION_KEY);

		ArrayList tabs = new ArrayList(10);
		tabs.add(new AppletMainTab());
		tabs.add(new AppletParametersTab());
		tabs.add(new AppletArgumentsTab());
		if (isProfilingEnabled) tabs.add(new ProfileTab(false));
		tabs.add(new JavaClasspathTab());
		tabs.add(new SourceLookupTab());
		tabs.add(new CommonTab());

		AbstractLaunchConfigurationTab[] array = new AbstractLaunchConfigurationTab[tabs.size()];
		tabs.toArray(array);
		setTabs(array);
	}
}

