/*******************************************************************************
 * Copyright (c) 2004 Hyades project. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Common
 * Public License v1.0 which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: IBM - Initial API and implementation
 ******************************************************************************/

package org.eclipse.hyades.trace.ui.internal.util;

import java.util.Enumeration;
import java.util.Vector;

import org.eclipse.hyades.internal.execution.local.control.Process;

public class ProfilingProcessList {

	private Vector items;

	public ProfilingProcessList() {
		items = new Vector();
	}

	public void initializeFromProcesses(Object[] p_items) {
		items.clear();

		for (int i = 0; i < p_items.length; i++) {
			items.addElement(p_items[i]);
		}
	}

	public void addProcess(Object item) {
		items.addElement(item);
	}

	public void removeProcess(Object item) {
		items.removeElement(item);
	}

	public Object[] getProcesses() {
		return items.toArray();
	}

	public int getProcessCount() {
		return items.size();
	}

	public Object getProcessForPID(String PID) {
		for (int i = 0; i < items.size(); i++) {
				Process process = getProcessFromItem(items.elementAt(i));
				
				try {
					if (process != null && PID != null && PID.equals(process.getProcessId())) {
						return items.elementAt(i);
					}
				} catch (Exception e) {
	
			}
		}

		return null;
	}

	public Object[] getPIDs() {
		Vector PIDs = new Vector();

		for (int i = 0; i < items.size(); i++) {
			Process process = getProcessFromItem(items.elementAt(i));
			try {
				if (process != null)
					PIDs.addElement(process.getProcessId());
			} catch (Exception e) {

			}
		}

		return PIDs.toArray();
	}

	public Object[] getAllAgents() {
		Vector agentsV = new Vector();

		for (int i = 0; i < items.size(); i++) {
			Process process = getProcessFromItem(items.elementAt(i));
			
			if (process != null)
			{
				Enumeration agents = process.listAgents();
	
				while (agents.hasMoreElements()) {
					agentsV.addElement(agents.nextElement());
				}
			}
		}

		return agentsV.toArray();
	}
	
	private Process getProcessFromItem(Object obj)
	{
		if (obj instanceof ProcessTreeItem)
		{
			if (((ProcessTreeItem)obj).getData() instanceof Process)
				return (Process)((ProcessTreeItem)obj).getData(); 
		}
		return null;
	}
	
}
