/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;

/**
 * Standard workbench wizard for importing resources from a xml trace file
 * into the workspace.
 */
public class ImportXMLTraceWizard extends Wizard
								  implements IImportWizard
{
	private IWorkbench workbench;
	private IStructuredSelection selection;
	private ImportTracePage1 mainPage;
	private boolean success = true;
/**
 * Creates a wizard for importing resources into the workspace from
 * a zip file.
 */
public ImportXMLTraceWizard() {
	AbstractUIPlugin plugin = UIPlugin.getDefault();
	IDialogSettings workbenchSettings = plugin.getDialogSettings();
	IDialogSettings section = workbenchSettings.getSection("ZipFileImportWizard");//$NON-NLS-1$
	if(section == null)
		section = workbenchSettings.addNewSection("ZipFileImportWizard");//$NON-NLS-1$
	setDialogSettings(section);
}
/* (non-Javadoc)
 * Method declared on IWizard.
 */
public void addPages()
{
  	setWindowTitle(UIPlugin.getResourceString("IMPORT_XML_TRACE_TITLE"));	
  		
	super.addPages();
	mainPage = new ImportTracePage1(workbench,selection);
	addPage(mainPage);
}
/* (non-Javadoc)
 * Method declared on IWorkbenchWizard.
 */
public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
	this.workbench = workbench;
	selection = currentSelection;

	setDefaultPageImageDescriptor(PDPluginImages.getImageDescriptor(PDPluginImages.IMG_UI_WZ_IMPORT_PROF));
	setNeedsProgressMonitor(true);
}
/* (non-Javadoc)
 * Method declared on IWizard.
 */
public boolean performFinish()
{
	return mainPage.finish();
}
}
