/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.*;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.jface.wizard.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.ui.*;

public abstract class OpenAgentWizard extends Wizard implements INewWizard
{
  protected TRCAgentProxy fAgent;
   
	public OpenAgentWizard()
	{
		super();
		setWindowTitle(UIPlugin.getResourceString("STR_PROPERTIES"));	
	}  

	public abstract void addPages();
   

 	public TRCAgentProxy getAgent() {
		return fAgent;
	}

	public void init(IWorkbench workbench, IStructuredSelection selection)
	{
		if (selection instanceof IStructuredSelection)
		{
		  	Iterator enum = ((IStructuredSelection) selection).iterator();
	 	 	if (enum.hasNext())
	  		{
				Object obj = enum.next();
				if (obj instanceof TRCAgentProxy)
		  			fAgent = (TRCAgentProxy) obj;
	  		}
		}
		setDefaultPageImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_AGENT_PROP));
  	}
  	
  	public abstract boolean performFinish();

}
