/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import java.util.Iterator;

import org.eclipse.hyades.uml2sd.ui.core.BaseMessage;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;

/**
 * @author sveyrier
 *
 */


public class GoToNextLifeline extends Action {

	protected SDView viewer = null;

	public GoToNextLifeline (IViewPart view)
	{
		if (view instanceof SDView)
			viewer = (SDView)view;
	}

	public void run ()
	{
		if (viewer == null)
			return;
		SDWidget sdWidget = viewer.getSDWidget();
		Frame frame = viewer.getFrame();
		if (frame==null || sdWidget==null)
			return;
		ISelectionProvider selProvider = sdWidget.getSelectionProvider();
		ISelection sel=selProvider.getSelection();
		Object selectedNode= null;
		Iterator  it = ((StructuredSelection)sel).iterator();
		while (it.hasNext())
		{
			Object node = it.next();
			if ((node instanceof BaseMessage)||(node instanceof Lifeline))
				selectedNode = node;
		}
		GraphNode node=null;
		if ((selectedNode == null)&&(frame.lifeLinesCount()>0))
			node = frame.getLifeline(0);
		else 
		{
			if (selectedNode instanceof BaseMessage)
			{
				 if (((BaseMessage)selectedNode).getStartLifeline()!=null)
					selectedNode = ((BaseMessage)selectedNode).getStartLifeline();
			}
			for (int i=0;i<frame.lifeLinesCount();i++)
			{
				if ((selectedNode == frame.getLifeline(i))
					&& (i<frame.lifeLinesCount()-1))
				{
					node = frame.getLifeline(i+1);
					break;
				}
			}
		}
		if (node != null)
		{
			sdWidget.clearSelection();
			sdWidget.addSelection(node);
			sdWidget.ensureVisible(node);
//			sdWidget.setFocusNode(node);
			sdWidget.redraw();
		}
	}
}
