/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.provider;

import org.eclipse.hyades.uml2sd.ui.core.Lifeline;

/**
 * Sequence diagram loaders which want to support Drag and Drop collapsing in the 
 * sequence diagram must implement this interface and register this implementation using
 * SDViewer.setCollapsingProvider();
 * 
 * @author sveyrier
 */
public interface ISDCollapseProvider {
	
	/**
	 * Called back when the sequence diagram is requesting 2 lifelines collapsing
	 * @param lifeline1 - One of the lifeline to collapse
	 * @param Lifeline2 - The other lifeline to collapse with
	 */
	public void collapseTwoLifelines(Lifeline lifeline1, Lifeline lifeline2);

}
