/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.dialogs.DialogSettings;


/**
 * A filter criteria is a criteria that can be activated or not, positive or not.
 */
public class FilterCriteria {

	protected static final String ACTIVE = "active"; //$NON-NLS-1$
	protected static final String POSITIVE = "positive"; //$NON-NLS-1$
	protected static final String LOADERCLASSNAME = "loaderClassName"; //$NON-NLS-1$

	private Criteria criteria;
	private boolean active;
	private boolean positive;
	private String loaderClassName;
	
	/**
	 * @param criteria_
	 * @param active_
	 * @param positive_
	 */
	public FilterCriteria(Criteria criteria_, boolean active_, boolean positive_) {
		setCriteria(criteria_);
		setActive(active_);
		setPositive(positive_);
	}
	
	/**
	 * @param criteria_
	 * @param active_
	 * @param positive_
	 * @param loaderClassName_
	 */
	public FilterCriteria(Criteria criteria_, boolean active_, boolean positive_, String loaderClassName_) {
		setCriteria(criteria_);
		setActive(active_);
		setPositive(positive_);
		setLoaderClassName(loaderClassName_);
	}
	
	protected FilterCriteria() {
	}
	
	/**
	 * @param criteria_
	 */
	public void setCriteria(Criteria criteria_) {
		criteria = criteria_;
	}
	
	public Criteria getCriteria() {
		return criteria;
	}
	
	/**
	 * @param active_
	 */
	public void setActive(boolean active_) {
		active = active_;
	}
	
	
	public boolean isActive() {
		return active;
	}
	
	/**
	 * @param positive The positive to set.
	 */
	public void setPositive(boolean positive_) {
		positive = positive_;
	}

	/**
	 * @return Returns the positive.
	 */
	public boolean isPositive() {
		return positive;
	}

	/**
	 * @return Returns the class loader name.
	 */
	public void setLoaderClassName(String loaderClassName_) {
		loaderClassName = loaderClassName_;
	}

	/**
	 * @return Returns the class loader name.
	 */
	public String getLoaderClassName() {
		return loaderClassName;
	}
	
	public static FilterCriteria find(FilterCriteria what, List list) {
		if (what != null && list != null) {
			try {
				for (Iterator i = list.iterator(); i.hasNext(); ) {
					FilterCriteria fc = (FilterCriteria)i.next();
					if (what.equals(fc)) {
						return fc;
					}
				}
			} catch (Exception e) {
				// Silence
			}
		}
		return null;
	}
	
	public boolean equals(FilterCriteria to) {
		if (isPositive() == to.isPositive() &&
			getLoaderClassName() == to.getLoaderClassName() &&
			getCriteria().equals(to.getCriteria())) {
			return true;
		}
		return false;
	}

	public void save(DialogSettings settings) {
		settings.put(ACTIVE,isActive());
		settings.put(POSITIVE,isPositive());
		if (getLoaderClassName() != null) {
			settings.put(LOADERCLASSNAME, getLoaderClassName());
		} else {
			settings.put(LOADERCLASSNAME, ""); //$NON-NLS-1$
		}
		if (criteria!=null)
			criteria.save(settings);
	}

	/**
	 * @param settings
	 */
	public void load(DialogSettings settings) {
		setActive(settings.getBoolean(ACTIVE));
		setPositive(settings.getBoolean(POSITIVE));
		String loaderClassName_ = settings.get(LOADERCLASSNAME);
		setLoaderClassName(loaderClassName_ != null && loaderClassName_.length() > 0 ? loaderClassName_ : null);
		if (criteria!=null)
			criteria.load(settings);
	}
}