/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.dialog;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceContentProvider;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceLabelProvider;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class EObjectResourceSelectionDialog
extends Dialog
implements SelectionListener,
IDoubleClickListener {
    private String[] fileExtensions;
    private String title;
    private Button filterButton;
    private TreeViewer hostViewer;
    private EObjectResourceContentProvider contentProvider;
    private Image fileImage;
    private EObject[] selectedEObjects;

    public EObjectResourceSelectionDialog(Shell parentShell, String title, String[] theFileExtensions, Image fileImage) {
        super(parentShell);
        this.title = title;
        this.fileExtensions = theFileExtensions;
        this.fileImage = fileImage;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 300;
        gridData.widthHint = 250;
        composite.setLayoutData((Object)gridData);
        this.filterButton = new Button(composite, 32);
        this.filterButton.setText(TestUIPlugin.getString("SHOW_FOLDERS"));
        this.filterButton.addSelectionListener((SelectionListener)this);
        this.createViewer(composite);
        this.hostViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        ((Tree)this.hostViewer.getControl()).addSelectionListener((SelectionListener)this);
        this.hostViewer.expandToLevel(2);
        return composite;
    }

    protected StructuredViewer createViewer(Composite parent) {
        Tree tree = new Tree(parent, 67586);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        this.contentProvider = new EObjectResourceContentProvider(this.fileExtensions);
        this.hostViewer = new TreeViewer(tree);
        this.hostViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.hostViewer.setLabelProvider((IBaseLabelProvider)new EObjectResourceLabelProvider(true, this.fileImage));
        this.hostViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.contentProvider.setFilter(2);
        ViewerSorter sorter = new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                if (elements.length > 0) {
                    super.sort(viewer, elements);
                }
            }

            public int category(Object element) {
                if (element instanceof IResource) {
                    return 0;
                }
                return 10;
            }
        };
        this.hostViewer.setSorter(sorter);
        return this.hostViewer;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.filterButton) {
            this.contentProvider.setFilter(this.filterButton.getSelection() ? 4 : 2);
            ISelection selection = this.hostViewer.getSelection();
            this.hostViewer.refresh();
            if (!selection.isEmpty()) {
                this.hostViewer.setSelection(selection, true);
            }
        }
        if (e.widget == this.hostViewer.getControl()) {
            this.setSelection();
        }
    }

    private void setSelection() {
        ISelection selection = this.hostViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            Vector<EObject> objects = new Vector<EObject>();
            while (it.hasNext()) {
                Object element = it.next();
                if (!(element instanceof EObject)) continue;
                objects.add((EObject)element);
            }
            this.selectedEObjects = new EObject[objects.size()];
            int i = 0;
            while (i < objects.size()) {
                this.selectedEObjects[i] = (EObject)objects.get(i);
                ++i;
            }
        }
    }

    public EObject[] getSelectedObjects() {
        if (this.selectedEObjects == null) {
            this.selectedEObjects = new EObject[0];
        }
        return this.selectedEObjects;
    }

    public IFile[] getSelectedFiles() {
        if (this.selectedEObjects == null) {
            return new IFile[0];
        }
        IFile[] selectedFiles = new IFile[this.selectedEObjects.length];
        int i = 0;
        while (i < this.selectedEObjects.length) {
            selectedFiles[i] = EMFUtil.getWorkspaceFile(this.selectedEObjects[i]);
            ++i;
        }
        return selectedFiles;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getViewer() == this.hostViewer) {
            this.setSelection();
            this.buttonPressed(0);
        }
    }
}

