/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.form.util;

import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ScrollableSectionForm;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class EditorForm
extends ScrollableSectionForm
implements IDisposable,
ISetSelectionTarget {
    private BaseEditorExtension baseEditorExtension;
    private WidgetFactory widgetFactory;

    public EditorForm(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        this();
        this.init(baseEditorExtension, widgetFactory);
    }

    public EditorForm() {
        this.setHeadingImage(TestUIImages.INSTANCE.getImage("form_banner.gif"));
        this.setVerticalFit(true);
    }

    public void init(BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        this.baseEditorExtension = baseEditorExtension;
        this.widgetFactory = widgetFactory;
    }

    public void dispose() {
        this.baseEditorExtension = null;
        this.widgetFactory = null;
        super.dispose();
    }

    public void updateTitle() {
    }

    public Control createControl() {
        Control control = this.createControl(this.baseEditorExtension.getHyadesEditorPart().getContainer());
        this.update();
        return control;
    }

    public void selectReveal(ISelection selection) {
    }

    public WidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public BaseEditorExtension getBaseEditorExtension() {
        return this.baseEditorExtension;
    }

    protected void createFormClient(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)GridDataUtil.createFill());
        this.createEditorFormContents(parent);
        this.load();
    }

    protected abstract void createEditorFormContents(Composite var1);

    public abstract void load();

    protected Composite createColumn(Composite parent) {
        Composite column = this.getFactory().createComposite(parent);
        column.setLayoutData((Object)GridDataUtil.createFill());
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        gridLayout.marginWidth = 0;
        column.setLayout((Layout)gridLayout);
        return column;
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorSite editorSite = this.getBaseEditorExtension().getHyadesEditorPart().getEditorPart().getEditorSite();
        IActionBars actionBars = editorSite.getActionBars();
        if (actionBars != null) {
            return actionBars.getStatusLineManager();
        }
        return null;
    }

    public boolean activated() {
        return false;
    }

    public ISelection getCurrentSelection() {
        return null;
    }

    protected static class ArgByReference {
        public Object arg;

        protected ArgByReference() {
        }
    }
}

