/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SharedPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public abstract class SharedPartWithButtons
extends SharedPart {
    private String[] buttonLabels;
    private Control[] controls;
    private Composite buttonContainer;

    public SharedPartWithButtons(String[] buttonLabels) {
        this.buttonLabels = buttonLabels;
    }

    public void setButtonEnabled(int index, boolean enabled) {
        Control c;
        if (this.controls != null && index >= 0 && this.controls.length > index && (c = this.controls[index]) instanceof Button) {
            c.setEnabled(enabled);
        }
    }

    public String getButtonLabel(int index) {
        return this.buttonLabels[index];
    }

    public Menu getButtonMenu(int index) {
        if (this.controls[index].getMenu() == null) {
            this.controls[index].setMenu(new Menu(this.controls[index]));
        }
        return this.controls[index].getMenu();
    }

    protected abstract void createMainControl(Composite var1, int var2, int var3, FormWidgetFactory var4);

    protected abstract void buttonSelected(Button var1, int var2);

    public void createControl(Composite parent, int style, int span, FormWidgetFactory factory) {
        this.createMainLabel(parent, span, factory);
        this.createMainControl(parent, style, span - 1, factory);
        if (this.buttonLabels != null && this.buttonLabels.length > 0) {
            this.buttonContainer = this.createComposite(parent, factory);
            GridData gd = new GridData(1040);
            this.buttonContainer.setLayoutData((Object)gd);
            this.buttonContainer.setLayout((Layout)this.createButtonsLayout());
            this.controls = new Control[this.buttonLabels.length];
            SelectionHandler listener = new SelectionHandler();
            int i = 0;
            while (i < this.buttonLabels.length) {
                String label = this.buttonLabels[i];
                if (label != null) {
                    Button button = this.createButton(this.buttonContainer, label, i, factory);
                    button.addSelectionListener((SelectionListener)listener);
                    this.controls[i] = button;
                } else {
                    this.createEmptySpace(this.buttonContainer, 1, factory);
                }
                ++i;
            }
        }
    }

    protected GridLayout createButtonsLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected Button createButton(Composite parent, String label, int index, FormWidgetFactory factory) {
        Button button;
        if (factory != null) {
            button = factory.createButton(parent, label, 8);
        } else {
            button = new Button(parent, 8);
            button.setText(label);
        }
        GridData gd = new GridData(770);
        button.setLayoutData((Object)gd);
        button.setData((Object)new Integer(index));
        return button;
    }

    protected void updateEnabledState() {
        int i = 0;
        while (i < this.controls.length) {
            Control c = this.controls[i];
            if (c instanceof Button) {
                c.setEnabled(this.isEnabled());
            }
            ++i;
        }
    }

    protected void createMainLabel(Composite parent, int span, FormWidgetFactory factory) {
    }

    private class SelectionHandler
    implements SelectionListener {
        private SelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.buttonSelected(e);
        }

        private void buttonSelected(SelectionEvent e) {
            Integer index = (Integer)e.widget.getData();
            SharedPartWithButtons.this.buttonSelected((Button)e.widget, index);
        }
    }
}

