/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.util;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.configuration.CFGMachine;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.util.LocationUtil;

public class DeploymentCompatibilityConverter {
    public static void convert(TPFDeployment deployment) throws Exception {
        EList oldLocations = deployment.getLocations();
        if (oldLocations.isEmpty()) {
            return;
        }
        CFGMachine[] oldMachines = new CFGMachine[oldLocations.size()];
        int index = 0;
        Iterator i = oldLocations.iterator();
        while (i.hasNext()) {
            oldMachines[index] = (CFGMachine)i.next();
            ++index;
        }
        index = 0;
        while (index < oldMachines.length) {
            String name = oldMachines[index].getName();
            String description = oldMachines[index].getDescription();
            String hostname = oldMachines[index].getHostName();
            CFGMachineConstraint newMachine = Common_ConfigurationFactory.eINSTANCE.createCFGMachineConstraint();
            newMachine.setName(name);
            newMachine.setDescription(description);
            newMachine.setHostname(hostname);
            String filename = name + "." + "location";
            IFile deployFile = EMFUtil.getWorkspaceFile((EObject)deployment);
            IFile file = deployFile.getWorkspace().getRoot().getFile(deployFile.getParent().getFullPath().append(filename));
            Resource resource = LocationUtil.createResource(file);
            resource.getContents().add((Object)newMachine);
            EMFUtil.save(resource);
            deployment.getRefLocations().add((Object)newMachine);
            deployment.getLocations().remove((Object)oldMachines[index]);
            ++index;
        }
    }
}

