/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypedElementFactoryManager;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TypedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.extension.AssociationMappingRegistry;
import org.eclipse.swt.graphics.Image;

public class DefaultTestSuiteProxyNode
extends TypedElementProxyNode
implements ITestSuiteProxyNode {
    private IAssociationDescriptor descriptor;
    private CMNNamedElementProxyNode[] testCases;

    public DefaultTestSuiteProxyNode(TPFTestSuite ts, Object parent) {
        super((TPFTest)ts, parent);
        AssociationMappingRegistry registry = (AssociationMappingRegistry)TestUIExtension.getTestSuiteMappingRegistry();
        IAssociationMapping associationMapping = registry.getAssociationMapping("typeDescriptions");
        this.descriptor = associationMapping.getDefaultAssociationDescriptor(ts.getType());
        LinkedList<IProxyNode> tcProxies = new LinkedList<IProxyNode>();
        EList testcases = ts.getTestCases();
        Iterator iter = testcases.iterator();
        while (iter.hasNext()) {
            TPFTestCase tc = (TPFTestCase)iter.next();
            ITypedElementProxyFactory factory = TypedElementFactoryManager.getInstance().getFactory(tc.getType());
            if (factory == null) continue;
            tcProxies.add(factory.create((TPFTest)tc, (Object)this));
        }
        this.testCases = tcProxies.toArray(new CMNNamedElementProxyNode[tcProxies.size()]);
    }

    public Image getImage() {
        if (this.descriptor == null) {
            return TestUIImages.INSTANCE.getImage("testsuite_obj.gif");
        }
        return this.descriptor.getImage();
    }

    public IProxyNode[] getChildren() {
        return this.testCases;
    }

    public TPFTestSuite getTestSuite() {
        EObject ts = EMFUtil.getResourceSet().getEObject(this.getOriginatorURI(), true);
        if (ts instanceof TPFTestSuite) {
            return (TPFTestSuite)ts;
        }
        return null;
    }
}

