/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.navigator.proxy;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.ArtifactFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DatapoolFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DeploymentFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.ExecutionFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.FileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.LocationFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestComponentFileProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.TestSuiteFileProxyNode;
import org.eclipse.hyades.test.ui.navigator.DefaultHyadesProxyNodeFactory;
import org.eclipse.hyades.test.ui.navigator.IFileProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;

public class EMFResourceProxyFactory
implements IFileProxyFactory {
    private FileProxyNode createFileProxy(IFile file, Resource resource) {
        String extension = file.getFileExtension();
        String fileName = file.getName();
        fileName = fileName.substring(0, fileName.length() - extension.length() - 1);
        if (extension != null) {
            if (extension.equals("artifact")) {
                return new ArtifactFileProxyNode(file, resource);
            }
            if (extension.equals("datapool")) {
                return new DatapoolFileProxyNode(file, resource);
            }
            if (extension.equals("location")) {
                return new LocationFileProxyNode(file, resource);
            }
            if (extension.equals("deploy")) {
                return new DeploymentFileProxyNode(file, resource);
            }
            if (extension.equals("testsuite")) {
                return new TestSuiteFileProxyNode(file, resource);
            }
            if (extension.equals("testcomponent")) {
                return new TestComponentFileProxyNode(file, resource);
            }
            if (extension.equals("execution")) {
                return new ExecutionFileProxyNode(file, resource);
            }
            return null;
        }
        return null;
    }

    private Resource getEMFResource(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        ResourceSet rs = EMFUtil.getResourceSet();
        return rs.getResource(uri, true);
    }

    public IProxyNode create(IFile file) {
        IProxyNode res = null;
        Resource resource = this.getEMFResource(file);
        if (resource != null) {
            EObject[] eObjects = (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
            if (eObjects.length != 0) {
                res = eObjects.length == 1 && !"execution".equals(file.getFileExtension()) ? DefaultHyadesProxyNodeFactory.getInstance().create(eObjects[0], file.getParent()) : this.createFileProxy(file, resource);
            }
            resource.unload();
        }
        return res;
    }
}

