/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.http.internal.reports;

import java.util.List;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.util.ExecutionUtil;
import org.eclipse.hyades.test.http.internal.reports.ResultsSelectionWizard;
import org.eclipse.hyades.test.http.junit.TypeValidator;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.hyades.ui.report.IReportGenerator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public abstract class HTTPReportGenerator
implements IReportGenerator {
    protected StructuredSelection selection;
    protected TPFTest test = null;
    protected TPFExecutionResult result = null;
    private List results;

    public void setUsedClasspath(String string) {
    }

    public String getReportFileExtension(ISelection iSelection) {
        return "html";
    }

    public boolean isAvailable(ISelection iSelection) {
        StructuredSelection structuredSelection = new StructuredSelection((Object)iSelection);
        this.selection = (StructuredSelection)structuredSelection.getFirstElement();
        if (!(this.selection.getFirstElement() instanceof ITestSuiteProxyNode)) {
            return false;
        }
        this.test = ((ITestSuiteProxyNode)this.selection.getFirstElement()).getTestSuite();
        if (!new TypeValidator().isValidType(this.test.getType())) {
            return false;
        }
        this.results = ExecutionUtil.findExecutionResults((TPFTest)this.test);
        return this.results.size() > 0;
    }

    protected void initResultSelection() {
        if (this.results.size() > 1) {
            ResultsSelectionWizard resultsSelectionWizard = new ResultsSelectionWizard(this.results);
            new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)resultsSelectionWizard).open();
            this.result = resultsSelectionWizard.getSelectedResult();
        } else {
            this.result = this.results.size() == 1 ? (TPFExecutionResult)this.results.get(0) : null;
        }
    }
}

