/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.testgen.http;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.hyades.execution.testgen.http.ITRCNodeHandler;
import org.eclipse.hyades.execution.testgen.http.TRCContext;
import org.eclipse.hyades.execution.testgen.http.TRCElement;
import org.eclipse.hyades.execution.testgen.http.TRCNode;
import org.eclipse.hyades.internal.execution.testgen.TestgenException;

public class TRCNodeHandler
implements ITRCNodeHandler {
    protected TRCContext context;
    private static final String SPACES = "          ";

    public void init(TRCContext tRCContext) throws TestgenException {
        this.context = tRCContext;
    }

    public void node(TRCNode tRCNode) throws TestgenException {
    }

    protected static String getAttributeValue(String string, TRCNode tRCNode) {
        TRCElement tRCElement = tRCNode.getElement();
        TRCElement.TRCAttribute[] tRCAttributeArray = tRCElement.getAttributes();
        int n = 0;
        while (n < tRCAttributeArray.length) {
            if (tRCAttributeArray[n].name.equals(string)) {
                return tRCAttributeArray[n].value;
            }
            ++n;
        }
        return null;
    }

    protected static TRCNode getSubNode(String string, TRCNode tRCNode) {
        ListIterator listIterator = tRCNode.getSubNodes().listIterator();
        TRCNode tRCNode2 = null;
        while (listIterator.hasNext()) {
            tRCNode2 = (TRCNode)listIterator.next();
            if (tRCNode2.getName().equals(string)) break;
        }
        return tRCNode2;
    }

    protected static List getSubNodeList(String string, TRCNode tRCNode) {
        ArrayList<TRCNode> arrayList = new ArrayList<TRCNode>();
        ListIterator listIterator = tRCNode.getSubNodes().listIterator();
        while (listIterator.hasNext()) {
            TRCNode tRCNode2 = (TRCNode)listIterator.next();
            if (!tRCNode2.getName().equals(string)) continue;
            arrayList.add(tRCNode2);
        }
        return arrayList;
    }

    protected static void dumpVertexElementName(PrintStream printStream, int n, TRCElement tRCElement) {
        if (printStream != null) {
            printStream.println(SPACES.substring(1, n) + "* [" + tRCElement.getName() + "]");
        }
    }

    protected static void dumpElementName(PrintStream printStream, int n, TRCElement tRCElement) {
        if (printStream != null) {
            printStream.println(SPACES.substring(1, n) + "[" + tRCElement.getName() + "]");
        }
    }

    protected static void dumpElementAttributes(PrintStream printStream, int n, TRCElement tRCElement) {
        TRCElement.TRCAttribute[] tRCAttributeArray = tRCElement.getAttributes();
        int n2 = 0;
        while (n2 < tRCAttributeArray.length) {
            if (printStream != null) {
                printStream.println(SPACES.substring(1, n) + "([" + tRCAttributeArray[n2].name + "] = [" + tRCAttributeArray[n2].value + "])");
            }
            ++n2;
        }
    }

    protected static void dumpElementContent(PrintStream printStream, int n, TRCElement tRCElement) {
        if (printStream != null) {
            printStream.println(SPACES.substring(1, n) + "<" + tRCElement.getContent().trim() + ">");
        }
    }

    protected static void dumpFirstOrderSection(PrintStream printStream, TRCNode tRCNode) {
        if (printStream != null) {
            printStream.println();
        }
        TRCNodeHandler.dumpVertexElementName(printStream, 2, tRCNode.getElement());
        TRCNodeHandler.dumpElementAttributes(printStream, 4, tRCNode.getElement());
        ListIterator listIterator = tRCNode.getSubNodes().listIterator();
        while (listIterator.hasNext()) {
            TRCNode tRCNode2 = (TRCNode)listIterator.next();
            TRCElement tRCElement = tRCNode2.getElement();
            TRCNodeHandler.dumpElementName(printStream, 4, tRCElement);
            TRCNodeHandler.dumpElementAttributes(printStream, 6, tRCElement);
            TRCNodeHandler.dumpElementContent(printStream, 6, tRCElement);
        }
    }

    protected static void dumpSecondOrderSection(PrintStream printStream, TRCNode tRCNode, String[] stringArray) {
        if (printStream != null) {
            printStream.println();
        }
        TRCNodeHandler.dumpVertexElementName(printStream, 2, tRCNode.getElement());
        TRCNodeHandler.dumpElementAttributes(printStream, 4, tRCNode.getElement());
        ListIterator listIterator = tRCNode.getSubNodes().listIterator();
        while (listIterator.hasNext()) {
            TRCNode tRCNode2 = (TRCNode)listIterator.next();
            TRCElement tRCElement = tRCNode2.getElement();
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(tRCElement.getName())) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                TRCNodeHandler.dumpVertexElementName(printStream, 4, tRCElement);
                TRCNodeHandler.dumpElementAttributes(printStream, 6, tRCElement);
                ListIterator listIterator2 = tRCNode2.getSubNodes().listIterator();
                while (listIterator2.hasNext()) {
                    TRCNode tRCNode3 = (TRCNode)listIterator2.next();
                    TRCElement tRCElement2 = tRCNode3.getElement();
                    TRCNodeHandler.dumpElementName(printStream, 6, tRCElement2);
                    TRCNodeHandler.dumpElementAttributes(printStream, 8, tRCElement2);
                    TRCNodeHandler.dumpElementContent(printStream, 8, tRCElement2);
                }
                continue;
            }
            TRCNodeHandler.dumpElementName(printStream, 4, tRCElement);
            TRCNodeHandler.dumpElementAttributes(printStream, 6, tRCElement);
            TRCNodeHandler.dumpElementContent(printStream, 6, tRCElement);
        }
    }
}

