/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.eclipse.hyades.logging.core.SerializationException;
import org.eclipse.hyades.logging.core.XmlUtility;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentGenerator;
import org.w3c.dom.Document;

public abstract class GraphicDocumentGenerator
implements IGraphicDocumentGenerator,
Serializable {
    protected String graphicType;

    public String getGraphicType() {
        return this.graphicType;
    }

    public Document generateGraphicDocument(Document data) throws DataInputProcessingException {
        GraphicDocumentProperties properties = new GraphicDocumentProperties();
        properties.setDataDocument(data);
        return this.generateGraphicDocument(properties);
    }

    public String generateAndSerializeToString(GraphicDocumentProperties properties) throws DataInputProcessingException, IOException {
        Document generatedDocument = this.generateGraphicDocument(properties);
        return this.serializeGeneratedDocumentToString(generatedDocument);
    }

    public boolean generateAndSerializeToFile(GraphicDocumentProperties properties, String uri) throws DataInputProcessingException, IOException {
        Document generatedDocument = this.generateGraphicDocument(properties);
        if (generatedDocument != null) {
            return this.serializeGeneratedDocumentToFile(generatedDocument, uri);
        }
        return false;
    }

    public boolean serializeGeneratedDocumentToFile(Document generatedDocument, String uri) throws IOException {
        if (generatedDocument != null) {
            try {
                XmlUtility.serialize((Document)generatedDocument, (File)new File(uri));
                return true;
            }
            catch (SerializationException s) {
            }
        }
        return false;
    }

    public String serializeGeneratedDocumentToString(Document generatedDocument) throws IOException {
        if (generatedDocument != null) {
            try {
                return XmlUtility.serialize((Document)generatedDocument);
            }
            catch (SerializationException s) {
            }
        }
        return null;
    }

    public static byte[] serializeGeneratedDocumentToStream(Document generatedDocument) {
        if (generatedDocument != null) {
            try {
                return XmlUtility.serializeAsByteArray((Document)generatedDocument);
            }
            catch (SerializationException t) {
            }
        }
        return null;
    }
}

