/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.SVGLineChart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGScatterChart
extends SVGLineChart
implements IGraphicDocumentStyle,
IDataInputProcessingExceptionCodes,
Serializable {
    public SVGScatterChart() {
        this.graphicType = "scatter";
    }

    public Document generateGraphicDocument(GraphicDocumentProperties input) throws DataInputProcessingException {
        double maxAlloableLegendWidth;
        double maxLengthOfLegendLableWidth;
        double maxAllowableYMarkerWidth;
        GraphicAttributes graphicAttrs = this.createGraphicAttributes(input);
        Document newDataDocument = graphicAttrs.getDataDocument();
        int numberOfDatasets = 0;
        String[] legendFlyOverLabels = null;
        try {
            numberOfDatasets = this.dataRetriever.getNumberOfDatasets(newDataDocument);
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.graphicType);
            throw e;
        }
        String rangeMaxValue = null;
        int gridXOffset = 60;
        int halfGridXOffset = gridXOffset / 2;
        int gridYOffset = 50;
        int xAxisLength = 0;
        try {
            this.xAxis = this.dataRetriever.getDataRange(newDataDocument, "S");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.getGraphicType());
            throw e;
        }
        try {
            this.yAxis = this.dataRetriever.getDataRange(newDataDocument, "W");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.getGraphicType());
            throw e;
        }
        if (this.xAxis == null || this.yAxis == null) {
            throw new DataInputProcessingException("", 126, "dataRange", this.getGraphicType());
        }
        if (this.xAxis.getType() != 0 || this.yAxis.getType() != 0) {
            throw new DataInputProcessingException("", 129, "dataRange", this.getGraphicType());
        }
        this.xMarkers = this.xAxis.getSegmentMarkers();
        this.yMarkers = this.yAxis.getSegmentMarkers();
        if (this.yMarkers != null && this.yMarkers.length > 0) {
            rangeMaxValue = this.yMarkers[this.yMarkers.length - 1].getValueString();
        }
        this.dataSets = new DataSet[numberOfDatasets];
        int i = 0;
        while (i < numberOfDatasets) {
            this.dataSets[i] = this.dataRetriever.getDatasetWithPosition(newDataDocument, Integer.toString(i));
            ++i;
        }
        legendFlyOverLabels = this.getLegendFlyOverLabels(this.dataSets);
        double maxLengthOfYmarkerWidth = this.getMaxLengthOfYmarker(this.yMarkers, graphicAttrs);
        if (maxLengthOfYmarkerWidth > (maxAllowableYMarkerWidth = (double)(graphicAttrs.getGraphicWidth() / 4))) {
            maxLengthOfYmarkerWidth = maxAllowableYMarkerWidth;
        }
        if ((maxLengthOfLegendLableWidth = this.getMaxLengthOfLegendLabel(graphicAttrs, this.dataSets)) > (maxAlloableLegendWidth = (double)(graphicAttrs.getGraphicWidth() / 3))) {
            maxLengthOfLegendLableWidth = maxAlloableLegendWidth;
        }
        if (graphicAttrs.isLegendSuppressed()) {
            maxLengthOfLegendLableWidth = 0.0;
        }
        xAxisLength = (int)((double)graphicAttrs.getGraphicWidth() - (maxLengthOfLegendLableWidth + maxLengthOfYmarkerWidth + (double)gridXOffset));
        int xLabelRowCount = this.getNumberOfAxisLabels(graphicAttrs, xAxisLength, this.xAxis);
        int yAxisLength = (int)((double)graphicAttrs.getGraphicHeight() - (double)gridYOffset * 2.5 - (double)(xLabelRowCount * 10));
        Document generatedDocument = this.createSvgDocument(newDataDocument.getImplementation(), Short.toString(graphicAttrs.getGraphicWidth()), Short.toString(graphicAttrs.getGraphicHeight()));
        Element svgRoot = generatedDocument.getDocumentElement();
        this.registerEventHandler(svgRoot, "onload", "init(evt)");
        this.addDefinitions(generatedDocument, graphicAttrs, numberOfDatasets);
        this.addExtraDefinitions(generatedDocument, graphicAttrs, numberOfDatasets, svgRoot);
        this.addJavaScriptFunctions(generatedDocument, graphicAttrs, numberOfDatasets, gridXOffset, gridYOffset, xAxisLength, yAxisLength);
        if (!graphicAttrs.isOutlineSuppressed()) {
            this.addOutline(generatedDocument, graphicAttrs);
        }
        if (!graphicAttrs.isTimestampSuppressed()) {
            try {
                String timestamp = this.dataRetriever.getTimestamp(newDataDocument);
                Date date = GraphicAttributes.parseISO8601Date(timestamp);
                this.addTimeStamp(generatedDocument, graphicAttrs, date == null ? timestamp : graphicAttrs.formatDate(date));
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        if (!graphicAttrs.isTitlebarSuppressed()) {
            this.addTitleBar(generatedDocument, graphicAttrs);
        } else {
            gridYOffset = super.resetGridOffsetForCenter(graphicAttrs.getGraphicHeight(), yAxisLength, 3.0);
        }
        if (!graphicAttrs.isUserPreferencesSuppressed() && graphicAttrs.getSvgFormatOnly()) {
            this.addPreferenceIcon(generatedDocument, graphicAttrs);
        }
        gridXOffset = halfGridXOffset + (int)maxLengthOfYmarkerWidth;
        this.addGrid(generatedDocument, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis);
        this.addAxisLabels(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis);
        this.addTitles(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis, xLabelRowCount, rangeMaxValue);
        Element gTextBoxElement = generatedDocument.createElement("g");
        this.addDataSets(generatedDocument, graphicAttrs, svgRoot, gTextBoxElement, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis, this.dataSets);
        if (!graphicAttrs.isLegendSuppressed()) {
            try {
                String[] legendLabels = this.dataRetriever.getLegendLabels(newDataDocument);
                this.addLegend(generatedDocument, graphicAttrs, gTextBoxElement, legendLabels, legendFlyOverLabels, (int)maxLengthOfYmarkerWidth + xAxisLength + halfGridXOffset, gridYOffset);
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        svgRoot.appendChild(gTextBoxElement);
        return generatedDocument;
    }

    protected Element addLegendItemGraphic(Document generatedDocument, Element parent, int index, int fontSize, int x, int y) {
        String[] flyOverShapeType = new String[]{"flyoverCircleshape", "flyoverSquareshape", "flyoverHorizontalrectshape", "flyoverVerticalrectshape", "flyoverTriangleshape", "flyoverDiamondshape"};
        Element gColourElement = super.addLegendItemGraphic(generatedDocument, parent, index, fontSize, x, y);
        gColourElement.setAttribute("onmouseover", "setVisibility('" + flyOverShapeType[index % flyOverShapeType.length] + "' , 'visible');");
        gColourElement.setAttribute("onmouseout", "setVisibility('" + flyOverShapeType[index % flyOverShapeType.length] + "' , 'hidden');");
        return gColourElement;
    }

    private void addDataSets(Document generatedDocument, GraphicAttributes attrs, Element parent, Element gTextBoxElement, int xAxisLength, int yAxisLength, int gridXOffset, int gridYOffset, DataRange xAxis, DataRange yAxis, DataSet[] dataSets) throws DataInputProcessingException {
        double xMin = xAxis.getMinValue();
        double xMax = xAxis.getMaxValue();
        double yMin = yAxis.getMinValue();
        double yMax = yAxis.getMaxValue();
        if (xMin == xMax || yMin == yMax) {
            return;
        }
        int i = 0;
        while (i < dataSets.length) {
            DataSet dataset = dataSets[i];
            DataPoint[] dps = dataset.getDataPoints();
            double[] yPositions = new double[dps.length];
            double[] xPositions = new double[dps.length];
            int j = 0;
            while (j < dps.length) {
                xPositions[j] = (double)xAxisLength * (dps[j].getValue1() - xMin) / (xMax - xMin);
                yPositions[j] = (double)yAxisLength * (yMax - dps[j].getValue2()) / (yMax - yMin);
                ++j;
            }
            this.addPoints(generatedDocument, parent, dps, i, xPositions, yPositions, xAxisLength, yAxisLength, gridXOffset, gridYOffset);
            String stylesheetClass = "dataValues anchorAtMiddle";
            Element gToggleElement = generatedDocument.createElement("g");
            gToggleElement.setAttribute("id", "textbox" + i);
            gToggleElement.setAttribute("class", stylesheetClass);
            gToggleElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
            gToggleElement.setAttribute("visibility", "hidden");
            gToggleElement.setAttribute("onclick", "toggleVisibility('textbox" + i + "');");
            gTextBoxElement.appendChild(gToggleElement);
            this.addTextBoxes(generatedDocument, attrs, gToggleElement, i, xPositions, yPositions, dps, xAxisLength, yAxisLength);
            ++i;
        }
    }

    private void addPoints(Document generatedDocument, Element parent, DataPoint[] dps, int linesetNumber, double[] xPositions, double[] yPositions, int xAxisLength, int yAxisLength, int gridXOffset, int gridYOffset) {
        double yNext;
        double xNext;
        String[] shapeType = new String[]{"#circleshape", "#squareshape", "#horizontalrectshape", "#verticalrectshape", "#triangleshape", "#diamondshape"};
        String[] flyoverShapeType = new String[]{"#flyoverCircleshape", "#flyoverSquareshape", "#flyoverHorizontalrectshape", "#flyoverVerticalrectshape", "#flyoverTriangleshape", "#flyoverDiamondshape"};
        double[] shapeWidth = new double[]{5.6, 5.6, 5.6, 2.8, 5.6, 5.6};
        double[] shapeHeight = new double[]{5.6, 5.6, 2.8, 5.6, 4.85, 5.6};
        double BOX_HEIGHT = 18.0;
        int length = xPositions.length;
        double xPrevious = 0.0;
        double yPrevious = 0.0;
        Element gColourElement = generatedDocument.createElement("g");
        String pointAttribute = xPositions[0] + " " + yAxisLength;
        int i = 0;
        while (i < length) {
            xNext = xPositions[i];
            yNext = yPositions[i];
            pointAttribute = pointAttribute + ", " + xNext + " " + yNext;
            ++i;
        }
        pointAttribute = pointAttribute + ", " + xPositions[length - 1] + " " + yAxisLength;
        Element polygonElement = generatedDocument.createElement("polygon");
        polygonElement.setAttribute("id", "poly" + linesetNumber);
        polygonElement.setAttribute("points", pointAttribute);
        polygonElement.setAttribute("style", "fill-opacity: 0.0; stroke: black; stroke-width: 0;");
        polygonElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
        gColourElement.appendChild(polygonElement);
        gColourElement.setAttribute("id", "dataColour" + linesetNumber);
        gColourElement.setAttribute("class", "dataset" + linesetNumber);
        gColourElement.setAttribute("visibility", "visible");
        gColourElement.setAttribute("onclick", "toggleVisibility('textbox" + linesetNumber + "');");
        parent.appendChild(gColourElement);
        int shapeNumber = linesetNumber % shapeType.length;
        int i2 = 0;
        while (i2 < length) {
            xNext = xPositions[i2];
            yNext = yPositions[i2];
            double shapeX = xNext - shapeWidth[shapeNumber] / 2.0;
            if (shapeX <= 0.0) {
                shapeX = 0.0;
            } else if (shapeX + shapeWidth[shapeNumber] > (double)xAxisLength) {
                shapeX = (double)xAxisLength - shapeWidth[shapeNumber];
            }
            double shapeY = yNext - shapeHeight[shapeNumber] / 2.0;
            if (shapeY + shapeHeight[shapeNumber] > (double)yAxisLength) {
                shapeY = (double)yAxisLength - shapeHeight[shapeNumber];
            }
            Element shapeElement = generatedDocument.createElement("use");
            Element flyOverShapeElement = generatedDocument.createElement("use");
            if (dps[i2].getType() == 1) {
                shapeElement.setAttribute("xlink:href", "#holeshape");
            } else {
                shapeElement.setAttribute("xlink:href", shapeType[shapeNumber]);
            }
            flyOverShapeElement.setAttribute("xlink:href", flyoverShapeType[shapeNumber]);
            shapeElement.setAttribute("transform", "translate(" + ((double)gridXOffset + shapeX) + "," + ((double)gridYOffset + shapeY) + ")");
            if (shapeNumber == 2) {
                flyOverShapeElement.setAttribute("transform", "translate(" + ((double)gridXOffset + shapeX - 4.5) + "," + ((double)gridYOffset + shapeY - 3.5) + ")");
            } else if (shapeNumber == 3) {
                flyOverShapeElement.setAttribute("transform", "translate(" + ((double)gridXOffset + shapeX - 4.5) + "," + ((double)gridYOffset + shapeY - 7.0) + ")");
            } else if (shapeNumber == 4) {
                flyOverShapeElement.setAttribute("transform", "translate(" + ((double)gridXOffset + shapeX - 7.0) + "," + ((double)gridYOffset + shapeY - 9.0) + ")");
            } else {
                flyOverShapeElement.setAttribute("transform", "translate(" + ((double)gridXOffset + shapeX - 7.0) + "," + ((double)gridYOffset + shapeY - 7.0) + ")");
            }
            shapeElement.setAttribute("visibility", "visible");
            flyOverShapeElement.setAttribute("visibility", "hidden");
            gColourElement.appendChild(shapeElement);
            gColourElement.appendChild(flyOverShapeElement);
            xPrevious = xNext;
            yPrevious = yNext;
            ++i2;
        }
    }

    private void addExtraDefinitions(Document generatedDocument, GraphicAttributes attrs, int numberOfDatasets, Element parent) {
        Element defsElement = generatedDocument.createElement("defs");
        parent.appendChild(defsElement);
        Element gElement_flyoverSquare = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_flyoverSquare);
        gElement_flyoverSquare.setAttribute("id", "flyoverSquareshape");
        gElement_flyoverSquare.setAttribute("visibility", "hidden");
        Element flyoverSquareElement = generatedDocument.createElement("rect");
        gElement_flyoverSquare.appendChild(flyoverSquareElement);
        flyoverSquareElement.setAttribute("width", "20.0");
        flyoverSquareElement.setAttribute("height", "20.0");
        flyoverSquareElement.setAttribute("style", "fill-opacity:0.3;stroke-width:0");
        Element gElement_flyoverCircle = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_flyoverCircle);
        gElement_flyoverCircle.setAttribute("id", "flyoverCircleshape");
        gElement_flyoverCircle.setAttribute("visibility", "hidden");
        Element flyoverCircleElement = generatedDocument.createElement("circle");
        gElement_flyoverCircle.appendChild(flyoverCircleElement);
        flyoverCircleElement.setAttribute("r", "10.0");
        flyoverCircleElement.setAttribute("cx", "10.0");
        flyoverCircleElement.setAttribute("cy", "10.0");
        flyoverCircleElement.setAttribute("style", "fill-opacity:0.3;stroke-width:0");
        Element gElement_flyoverHole = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_flyoverHole);
        gElement_flyoverHole.setAttribute("id", "flyoverHoleshape");
        gElement_flyoverHole.setAttribute("visibility", "hidden");
        Element flyoverHoleElement = generatedDocument.createElement("circle");
        gElement_flyoverHole.appendChild(flyoverHoleElement);
        flyoverHoleElement.setAttribute("r", "2.8");
        flyoverHoleElement.setAttribute("cx", "2.8");
        flyoverHoleElement.setAttribute("cy", "2.8");
        flyoverHoleElement.setAttribute("style", "fill:none;");
        flyoverHoleElement.setAttribute("style", "fill-opacity:0.3;stroke-width:0");
        Element gElement_flyoverDiamond = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_flyoverDiamond);
        gElement_flyoverDiamond.setAttribute("id", "flyoverDiamondshape");
        gElement_flyoverDiamond.setAttribute("visibility", "hidden");
        Element flyoverDiamondElement = generatedDocument.createElement("polygon");
        gElement_flyoverDiamond.appendChild(flyoverDiamondElement);
        flyoverDiamondElement.setAttribute("points", "0,10 10,0 20,10 10,20");
        flyoverDiamondElement.setAttribute("style", "fill-opacity:0.3;stroke-width:0");
        Element gElement_flyoverHorizontalrectshape = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_flyoverHorizontalrectshape);
        gElement_flyoverHorizontalrectshape.setAttribute("id", "flyoverHorizontalrectshape");
        gElement_flyoverHorizontalrectshape.setAttribute("visibility", "hidden");
        Element flyoverHorizontalrectElement = generatedDocument.createElement("rect");
        gElement_flyoverHorizontalrectshape.appendChild(flyoverHorizontalrectElement);
        flyoverHorizontalrectElement.setAttribute("width", "15");
        flyoverHorizontalrectElement.setAttribute("height", "10");
        flyoverHorizontalrectElement.setAttribute("style", "fill-opacity:0.3;stroke-width:0");
        Element gElement_flyoverVerticalrectshape = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_flyoverVerticalrectshape);
        gElement_flyoverVerticalrectshape.setAttribute("id", "flyoverVerticalrectshape");
        gElement_flyoverVerticalrectshape.setAttribute("visibility", "hidden");
        Element flyoverVerticalrectElement = generatedDocument.createElement("rect");
        flyoverVerticalrectElement.setAttribute("width", "12");
        flyoverVerticalrectElement.setAttribute("height", "20");
        gElement_flyoverVerticalrectshape.appendChild(flyoverVerticalrectElement);
        gElement_flyoverVerticalrectshape.setAttribute("style", "fill-opacity:0.3;stroke-width:0");
        Element gElement_flyoverTriangleshape = generatedDocument.createElement("g");
        defsElement.appendChild(gElement_flyoverTriangleshape);
        gElement_flyoverTriangleshape.setAttribute("id", "flyoverTriangleshape");
        gElement_flyoverTriangleshape.setAttribute("visibility", "hidden");
        Element flyoverTriangleElement = generatedDocument.createElement("polygon");
        flyoverTriangleElement.setAttribute("points", "10 0, 0 20, 20 20");
        gElement_flyoverTriangleshape.appendChild(flyoverTriangleElement);
        gElement_flyoverTriangleshape.setAttribute("style", "fill-opacity:0.3;stroke-width:0");
    }

    protected GraphicAttributes createGraphicAttributes(GraphicDocumentProperties input) throws DataInputProcessingException {
        GraphicAttributes graphicAttrs = new GraphicAttributes();
        graphicAttrs.setGraphicWidth("450");
        graphicAttrs.setPreferencesPage("prefs_scatter.htm");
        graphicAttrs.setPreferencesPageWidth("430");
        graphicAttrs.setPreferencesPageHeight("435");
        graphicAttrs.setConfigDocument(input.getConfigDocument());
        graphicAttrs.setDataDocument(input.getDataDocument());
        this.getConfigAttributes(graphicAttrs);
        graphicAttrs.setAttributesFrom(input);
        return graphicAttrs;
    }
}

