/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.dialog;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DatapoolBaseDialog;
import org.eclipse.hyades.test.ui.datapool.internal.util.DatapoolUtil;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DatapoolDeleteColumnDialog
extends DatapoolBaseDialog
implements SelectionListener {
    private static final String TAG_VARIABLES = "variables";
    private IDatapool datapool = null;
    private Combo variableCombo = null;
    private String deletionVariableID = null;

    public DatapoolDeleteColumnDialog(Shell parentShell, IDatapool datapool) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.datapool = datapool;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(DatapoolPlugin.getResourceString("DATA_DEL_VAR_DLG_TITLE"));
        Composite superComposite = (Composite)super.createDialogArea(parent);
        GridData gridData = GridDataUtil.createFill();
        superComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        superComposite.setLayout((Layout)gridLayout);
        Label variableLabel = new Label(superComposite, 0);
        variableLabel.setText(DatapoolPlugin.getResourceString("DATA_DEL_VAR_DLG_SEL"));
        this.variableCombo = new Combo(superComposite, 12);
        IDatapoolVariable[] variables = DatapoolUtil.getInstance().getVariables(this.datapool, null);
        String[] variableLabels = this.getVariableLabels(variables);
        gridData = new GridData(256);
        this.variableCombo.setItems(variableLabels);
        this.variableCombo.setData(TAG_VARIABLES, (Object)variables);
        this.variableCombo.setLayoutData((Object)gridData);
        this.variableCombo.addSelectionListener((SelectionListener)this);
        return superComposite;
    }

    private boolean enableOK() {
        if (this.deletionVariableID == null) {
            this.getOKButton().setEnabled(false);
            return false;
        }
        this.getOKButton().setEnabled(true);
        return true;
    }

    private String[] getVariableLabels(IDatapoolVariable[] variables) {
        if (variables == null) {
            return null;
        }
        int listSize = variables.length;
        String[] returnList = new String[listSize];
        int i = 0;
        while (i < listSize) {
            IDatapoolVariable variable = variables[i];
            if (variable != null) {
                String name;
                returnList[i] = name = variable.getName();
            }
            ++i;
        }
        return returnList;
    }

    public void widgetSelected(SelectionEvent e) {
        Combo deleteVariableCombo = (Combo)e.widget;
        int selectionIndex = deleteVariableCombo.getSelectionIndex();
        IDatapoolVariable[] variables = (IDatapoolVariable[])deleteVariableCombo.getData(TAG_VARIABLES);
        if (selectionIndex >= 0 && selectionIndex < variables.length) {
            IDatapoolVariable variable = variables[selectionIndex];
            this.deletionVariableID = variable.getId();
        } else {
            this.deletionVariableID = new String();
        }
        this.enableOK();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public String getDeletedVariableID() {
        return this.deletionVariableID;
    }
}

