
import org.eclipse.hyades.analysis.engine.IAnalysisEngine;
import org.eclipse.hyades.analysis.engine.ISymptomDatabase;
import org.eclipse.hyades.analysis.engine.Incident;
import org.eclipse.hyades.analysis.engine.Solution;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Sample class to demonstrate the capability of creating an analysis engine.
 * <p>
 * An analysis engine is used to analyze log records within a log file against a
 * symptom database.
 * <p>
 * 
 * 
 * @author Nellie Chau
 * @author Paul E. Slauenwhite
 * @version September 15, 2004
 * @since September 15, 2004
 * @see org.eclipse.hyades.analysis.engine.IAnalysisEngine
 */
public class AnalysisEngineImpl implements IAnalysisEngine {

    private ISymptomDatabase symptomDatabase = null;

    public AnalysisEngineImpl() {
        symptomDatabase = new SymptomDatabaseImpl();
    }

    /**
     * @see org.eclipse.hyades.analysis.engine.IAnalysisEngine#reloadSymptomDatabase()
     */
    public boolean reloadSymptomDatabase() {
        return (symptomDatabase.load());
    }

    /**
     * @see org.eclipse.hyades.analysis.engine.IAnalysisEngine#mergeSymptomDatabase(java.lang.String)
     */
    public boolean mergeSymptomDatabase(String symptomDbPath) {
        return (symptomDatabase.merge(symptomDbPath));
    }

    /**
     * @see org.eclipse.hyades.analysis.engine.IAnalysisEngine#removeSymptomDatabase()
     */
    public boolean removeSymptomDatabase() {
        return (symptomDatabase.replace(null));
    }

    /**
     * @see org.eclipse.hyades.analysis.engine.IAnalysisEngine#replaceSymptomDatabase(java.lang.String)
     */
    public boolean replaceSymptomDatabase(String symptomDbPath) {

        if ((symptomDbPath != null) && (!symptomDbPath.trim().equals(""))) {
            return (symptomDatabase.replace(symptomDbPath));
        }

        return false;
    }

    /**
     * @see org.eclipse.hyades.analysis.engine.IAnalysisEngine#getSymptomDatabasePath()
     */
    public String getSymptomDatabasePath() {

        if (symptomDatabase != null) {
            return (symptomDatabase.getPath());
        }

        return null;
    }

    /**
     * @see org.eclipse.hyades.analysis.engine.IAnalysisEngine#analyze(org.eclipse.hyades.analysis.engine.Incident)
     */
    public Object[] analyze(Incident incident) {
        return (symptomDatabase.getDirectives(incident));
    }

    /**
     * @see org.eclipse.hyades.analysis.engine.IAnalysisEngine#analyzeForSolutions(org.eclipse.hyades.analysis.engine.Incident)
     */
    public Solution[] analyzeForSolutions(Incident incident) {
        return (symptomDatabase.getSolutions(incident));
    }
}