/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.collection.framework;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.hyades.execution.security.IClientHandler;
import org.eclipse.hyades.internal.execution.file.FileServiceConstants;
import org.eclipse.hyades.internal.execution.local.common.Constants;
import org.eclipse.hyades.internal.execution.local.common.Message;

public class FileClientHandlerImpl
extends Thread
implements IClientHandler,
FileServiceConstants,
Constants {
    private Socket _socket;
    private InputStream _instrm;
    private OutputStream _outstrm;
    private byte[] _data;
    private int byteCount;
    private int count;

    public FileClientHandlerImpl(Socket socket) {
        this._socket = socket;
        try {
            this._instrm = socket.getInputStream();
            this._outstrm = socket.getOutputStream();
        }
        catch (IOException iOException) {}
    }

    public byte[] getRemoteAddress() {
        return this._socket.getInetAddress().getAddress();
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3;
        try {
            n3 = this._instrm.read(byArray, n, n2);
        }
        catch (IOException iOException) {
            n3 = -1;
        }
        return n3;
    }

    public int write(byte[] byArray, int n, int n2) {
        try {
            this._outstrm.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            return -1;
        }
        return 0;
    }

    public void closeConnection() {
        block4: {
            try {
                this._instrm.close();
                this._outstrm.close();
                this._socket.close();
            }
            catch (IOException iOException) {
                if (this._socket.isClosed()) break block4;
                try {
                    this._socket.close();
                }
                catch (IOException iOException2) {}
            }
        }
    }

    public int write(byte[] byArray) {
        try {
            this._outstrm.write(byArray);
        }
        catch (IOException iOException) {
            return -9;
        }
        return 0;
    }

    public int read(byte[] byArray) {
        int n;
        try {
            n = this._instrm.read(byArray);
        }
        catch (IOException iOException) {
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFile(String string) {
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                this._data = new byte[1024];
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                while ((this.count = bufferedInputStream.read(this._data)) != -1) {
                    this.write(this._data, 0, this.count);
                    this.byteCount += this.count;
                }
                bufferedInputStream.close();
            }
            catch (Throwable throwable) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                }
                Object var6_4 = null;
                this.closeConnection();
            }
            Object var6_3 = null;
            this.closeConnection();
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.closeConnection();
            throw throwable;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int putFile(String string) {
        FilterOutputStream filterOutputStream = null;
        try {
            try {
                boolean bl;
                File file = new File(string);
                if (!file.isAbsolute()) {
                    throw new IOException();
                }
                String string2 = file.getParent();
                File file2 = new File(string2);
                if (!file2.exists() && !(bl = file2.mkdirs())) {
                    throw new IOException();
                }
                File file3 = new File(string);
                file3.createNewFile();
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
                this._data = new byte[1024];
                this._socket.setSoTimeout(3000);
                while ((this.count = this.read(this._data)) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(this._data, 0, this.count);
                    this.byteCount += this.count;
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                filterOutputStream.close();
            }
            catch (Throwable throwable) {
                try {
                    this._outstrm.write(-9);
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                }
                Object var8_11 = null;
                this.closeConnection();
            }
            Object var8_10 = null;
            this.closeConnection();
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            this.closeConnection();
            throw throwable;
        }
        return 0;
    }

    private int deleteFile(String string) {
        return 0;
    }

    public void run() {
        this._data = new byte[1024];
        int n = 0;
        int n2 = -1;
        int n3 = this.read(this._data);
        long l = Message.readRALongFromBuffer((byte[])this._data, (int)n);
        long l2 = Message.readRALongFromBuffer((byte[])this._data, (int)(n += 4));
        n += 4;
        String string = null;
        try {
            string = new String(this._data, n, (int)l2, "UTF-8");
        }
        catch (Throwable throwable) {
            string = new String(this._data, n, (int)l2);
        }
        switch ((int)l) {
            case 1: {
                n2 = this.getFile(string);
                break;
            }
            case 2: {
                n2 = this.putFile(string);
                break;
            }
            case 3: {
                n2 = this.deleteFile(string);
                break;
            }
        }
    }
}

