/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.hyades.internal.config.generator.Logger;
import org.eclipse.hyades.internal.config.generator.PlatformObject;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigUtility {
    private static String resourceLocation = "org.eclipse.hyades.internal.config.generator.SetConfig";
    private static String lineSeparator = System.getProperty("line.separator");
    protected static ResourceBundle resource = null;

    public static String getString(String string) {
        return ConfigUtility.getString(resourceLocation, string);
    }

    public static String getString(String string, String string2) {
        try {
            Logger.out("Using system class loader");
            resource = ResourceBundle.getBundle(string);
        }
        catch (MissingResourceException missingResourceException) {
            Logger.err(missingResourceException.getMessage());
        }
        if (resource != null) {
            Logger.out("Found resource: " + string);
            return resource.getString(string2);
        }
        Logger.err("Cannot find resource: " + string);
        return null;
    }

    public static String getString(ClassLoader classLoader, String string, String string2) {
        try {
            Logger.out("Using class loader: " + classLoader.toString());
            resource = ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            Logger.err(missingResourceException.getMessage());
        }
        if (resource != null) {
            Logger.out("Found resource: " + string);
            return resource.getString(string2);
        }
        Logger.err("Cannot find resource: " + string);
        return null;
    }

    public static String printElement(Node node) {
        return ConfigUtility.print(node, 0, false);
    }

    public static String print(Node node) {
        return ConfigUtility.print(node, 0, true);
    }

    public static String print(Node node, int n, boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ConfigUtility.tabs(n) + "<" + node.getNodeName());
        NamedNodeMap namedNodeMap = node.getAttributes();
        NodeList nodeList = node.getChildNodes();
        if (namedNodeMap != null) {
            n2 = 0;
            while (n2 < namedNodeMap.getLength()) {
                if (namedNodeMap.item(n2) instanceof Attr) {
                    stringBuffer.append(" ");
                    stringBuffer.append(((Attr)namedNodeMap.item(n2)).getName());
                    stringBuffer.append("=\"");
                    stringBuffer.append(((Attr)namedNodeMap.item(n2)).getValue());
                    stringBuffer.append("\"");
                }
                ++n2;
            }
        }
        if (!bl || nodeList == null || nodeList.getLength() == 0) {
            stringBuffer.append("/>" + lineSeparator);
        } else {
            stringBuffer.append(">" + lineSeparator);
            n2 = 0;
            while (n2 < nodeList.getLength()) {
                stringBuffer.append(ConfigUtility.print(nodeList.item(n2), n + 1, true));
                ++n2;
            }
            stringBuffer.append(ConfigUtility.tabs(n) + "</" + node.getNodeName() + ">" + lineSeparator);
        }
        return stringBuffer.toString();
    }

    protected static String tabs(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\t");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String removeTrailings(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string.trim();
            while (string2.endsWith(PlatformObject.sr)) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        }
        return string2;
    }

    public static String arrayToString(String[] stringArray) {
        StringBuffer stringBuffer = null;
        if (stringArray != null) {
            stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                if (n < stringArray.length - 1) {
                    stringBuffer.append(',');
                }
                ++n;
            }
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static String[] stringToArray(String string) {
        String[] stringArray = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
        }
        return stringArray;
    }

    public static String askUser(String string) {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        try {
            string2 = bufferedReader.readLine();
        }
        catch (IOException iOException) {
            string2 = string;
        }
        if (string2.equals("")) {
            string2 = string;
        }
        return ConfigUtility.removeTrailings(string2);
    }

    public static String getJvmLib(String string) throws IOException {
        String string2 = PlatformObject.sr;
        String string3 = PlatformObject.jvmLib;
        File file = null;
        String string4 = new String(string + string2 + "classic" + string2 + string3);
        file = new File(string4);
        if (file != null && file.exists()) {
            return file.getCanonicalPath();
        }
        string4 = new String(string + string2 + ".." + string2 + "jre" + string2 + "bin" + string2 + "classic" + string2 + string3);
        file = new File(string4);
        if (file != null && file.exists()) {
            return file.getCanonicalPath();
        }
        string4 = new String(string + string2 + "server" + string2 + string3);
        file = new File(string4);
        if (file != null && file.exists()) {
            return file.getCanonicalPath();
        }
        string4 = new String(string + string2 + ".." + string2 + "jre" + string2 + "bin" + string2 + "server" + string2 + string3);
        file = new File(string4);
        if (file != null && file.exists()) {
            return file.getCanonicalPath();
        }
        string4 = new String(string + string2 + "client" + string2 + string3);
        file = new File(string4);
        if (file != null && file.exists()) {
            return file.getCanonicalPath();
        }
        string4 = new String(string + string2 + ".." + string2 + "jre" + string2 + "bin" + string2 + "client" + string2 + string3);
        file = new File(string4);
        if (file != null && file.exists()) {
            return file.getCanonicalPath();
        }
        string4 = new String(string + string2 + ".." + string2 + "lib" + string2 + "i386" + string2 + "server" + string2 + string3);
        file = new File(string4);
        if (file != null && file.exists()) {
            return file.getCanonicalPath();
        }
        string4 = new String(string + string2 + ".." + string2 + "jre" + string2 + "lib" + string2 + "i386" + string2 + "server" + string2 + string3);
        file = new File(string4);
        if (file != null && file.exists()) {
            return file.getCanonicalPath();
        }
        string4 = new String(string + string2 + ".." + string2 + "lib" + string2 + "i386" + string2 + "client" + string2 + string3);
        file = new File(string4);
        if (file != null && file.exists()) {
            return file.getCanonicalPath();
        }
        string4 = new String(string + string2 + ".." + string2 + "jre" + string2 + "lib" + string2 + "i386" + string2 + "client" + string2 + string3);
        file = new File(string4);
        if (file != null && file.exists()) {
            return file.getCanonicalPath();
        }
        if (PlatformObject.name.equals("HP-UX")) {
            string4 = new String(string + string2 + ".." + string2 + "lib" + string2 + "PA_RISC" + string2 + "classic" + string2 + string3);
            file = new File(string4);
            if (file != null && file.exists()) {
                return file.getCanonicalPath();
            }
            string4 = new String(string + string2 + ".." + string2 + "jre" + string2 + "lib" + string2 + "PA_RISC" + string2 + "classic" + string2 + string3);
            file = new File(string4);
            if (file != null && file.exists()) {
                return file.getCanonicalPath();
            }
            string4 = new String(string + string2 + ".." + string2 + "lib" + string2 + "PA_RISC" + string2 + "server" + string2 + string3);
            file = new File(string4);
            if (file != null && file.exists()) {
                return file.getCanonicalPath();
            }
            string4 = new String(string + string2 + ".." + string2 + "jre" + string2 + "lib" + string2 + "PA_RISC" + string2 + "server" + string2 + string3);
            file = new File(string4);
            if (file != null && file.exists()) {
                return file.getCanonicalPath();
            }
        } else if (PlatformObject.name.equals("SunOS")) {
            string4 = new String(string + string2 + ".." + string2 + "lib" + string2 + "sparc" + string2 + string3);
            file = new File(string4);
            if (file != null && file.exists()) {
                return file.getCanonicalPath();
            }
            string4 = new String(string + string2 + ".." + string2 + "jre" + string2 + "lib" + string2 + "sparc" + string2 + string3);
            file = new File(string4);
            if (file != null && file.exists()) {
                return file.getCanonicalPath();
            }
            string4 = new String(string + string2 + ".." + string2 + "lib" + string2 + "sparc" + string2 + "server" + string2 + string3);
            file = new File(string4);
            if (file != null && file.exists()) {
                return file.getCanonicalPath();
            }
            string4 = new String(string + string2 + ".." + string2 + "jre" + string2 + "lib" + string2 + "sparc" + string2 + "server" + string2 + string3);
            file = new File(string4);
            if (file != null && file.exists()) {
                return file.getCanonicalPath();
            }
            string4 = new String(string + string2 + ".." + string2 + "lib" + string2 + "sparc" + string2 + "client" + string2 + string3);
            file = new File(string4);
            if (file != null && file.exists()) {
                return file.getCanonicalPath();
            }
            string4 = new String(string + string2 + ".." + string2 + "jre" + string2 + "lib" + string2 + "sparc" + string2 + "client" + string2 + string3);
            file = new File(string4);
            if (file != null && file.exists()) {
                return file.getCanonicalPath();
            }
        }
        return null;
    }
}

