/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import org.eclipse.hyades.internal.execution.local.common.Constants;

class RABinaryArray
implements Constants {
    protected byte[] _data;
    protected int _padding = 0;

    public RABinaryArray() {
    }

    public RABinaryArray(byte[] data) {
        if (data != null) {
            this._data = data;
            this.calculatePadding();
        } else {
            this._padding = 0;
        }
    }

    private void calculatePadding() {
        this._padding = 4 - this._data.length % 4;
        if (this._padding == 4) {
            this._padding = 0;
        }
    }

    public byte[] getData() {
        return this._data;
    }

    public int getPadding() {
        return this._padding;
    }

    public int getSize() {
        return 4 + this._data.length + this._padding;
    }

    public long length() {
        if (this._data != null) {
            return this._data.length;
        }
        return 0L;
    }

    public void setData(byte[] data) {
        this._data = data;
        this.calculatePadding();
    }

    public void setData(byte[] data, int offset, int length) {
        if (data != null) {
            this._data = new byte[length];
            System.arraycopy(data, offset, this._data, 0, length);
            this.calculatePadding();
        }
    }
}

