/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.jvm.threadanalysis;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.StkEntryNative;
import org.eclipse.hyades.collection.threadanalyzer.Thd;
import org.eclipse.hyades.logging.events.EventItemsFactory;
import org.eclipse.hyades.logging.events.IAssociatedEvent;
import org.eclipse.hyades.logging.events.IAssociationEngine;
import org.eclipse.hyades.logging.events.ICommonBaseEvent;
import org.eclipse.hyades.logging.events.IComponentIdentification;
import org.eclipse.hyades.logging.events.IExtendedDataElement;
import org.eclipse.hyades.logging.events.IReportSituation;
import org.eclipse.hyades.logging.events.ISimpleEventFactory;
import org.eclipse.hyades.logging.events.ISituation;
import org.eclipse.hyades.logging.events.ISituationType;
import org.eclipse.hyades.logging.events.SimpleEventFactoryImpl;
import org.eclipse.hyades.logging.jvm.threadanalysis.ThreadDumpProcessor;

public class ThreadDumpProcessorImpl
implements ThreadDumpProcessor {
    private ISimpleEventFactory _simpleEventFactory;
    private IComponentIdentification _compId;
    private ISituation _situation;
    private IAssociationEngine _associationEngine;

    public Vector generateCBEs(DumpData dumpData) {
        Vector vector = new Vector();
        IAssociatedEvent iAssociatedEvent = this._simpleEventFactory.createAssociatedEvent();
        this._compId.setComponent(dumpData.getDumpingJvmName());
        ICommonBaseEvent iCommonBaseEvent = this.createCBE("ThreadDump", null, vector);
        iCommonBaseEvent.addExtendedDataElement("Type", "Java");
        iCommonBaseEvent.addExtendedDataElement("Description", dumpData.getDescription());
        iCommonBaseEvent.addExtendedDataElement("DisplayName", dumpData.getDisplayName());
        ICommonBaseEvent iCommonBaseEvent2 = this.createCBE("Threads", iCommonBaseEvent, vector);
        IExtendedDataElement iExtendedDataElement = iCommonBaseEvent.addExtendedDataElementWithIntValue("Threads", dumpData.getThreads().size());
        this.addThreads(dumpData, iExtendedDataElement, iCommonBaseEvent2, vector);
        ICommonBaseEvent iCommonBaseEvent3 = this.createCBE("Monitors", iCommonBaseEvent, vector);
        IExtendedDataElement iExtendedDataElement2 = iCommonBaseEvent.addExtendedDataElementWithIntValue("Monitors", dumpData.getMonitors().size());
        this.addMonitors(dumpData, iExtendedDataElement2, iCommonBaseEvent3, vector);
        return vector;
    }

    private ICommonBaseEvent createCBE(String string, ICommonBaseEvent iCommonBaseEvent, Vector vector) {
        ICommonBaseEvent iCommonBaseEvent2 = this._simpleEventFactory.createCommonBaseEvent("CBE:" + string, new Date().getTime());
        iCommonBaseEvent2.setSeverity((short)10);
        iCommonBaseEvent2.setMsg(string);
        iCommonBaseEvent2.setSourceComponentId(this._compId);
        iCommonBaseEvent2.setSituation(this._situation);
        if (iCommonBaseEvent != null) {
            IAssociatedEvent iAssociatedEvent = this._simpleEventFactory.createAssociatedEvent();
            iAssociatedEvent.setAssociationEngineInfo(this._associationEngine);
            iAssociatedEvent.addResolvedEvent(iCommonBaseEvent2.getGlobalInstanceId());
            iCommonBaseEvent.addAssociatedEvent(iAssociatedEvent);
        }
        vector.add(iCommonBaseEvent2);
        return iCommonBaseEvent2;
    }

    private void addThreads(DumpData dumpData, IExtendedDataElement iExtendedDataElement, ICommonBaseEvent iCommonBaseEvent, Vector vector) {
        Thd thd;
        int n = 0;
        iCommonBaseEvent.addExtendedDataElementWithIntValue("Thread Count", dumpData.getThreads().size());
        Enumeration enumeration = dumpData.getThreadEnum();
        while ((thd = dumpData.getNextThread(enumeration)) != null) {
            this.createThreadCbe(iCommonBaseEvent, thd, n, vector);
            ++n;
        }
    }

    private IExtendedDataElement createThreadXde(IExtendedDataElement iExtendedDataElement, Thd thd, int n) {
        IExtendedDataElement iExtendedDataElement2 = iExtendedDataElement.addChildWithIntValue("Thread_" + n, n);
        iExtendedDataElement2.addChild("threadId", thd.getThreadId());
        iExtendedDataElement2.addChild("name", thd.getName());
        iExtendedDataElement2.addChild("priority", thd._priority);
        iExtendedDataElement2.addChild("state", thd._state);
        iExtendedDataElement2.addChildWithIntValue("waitMonitorID", thd.getWaitMonitorId());
        if (thd._waitMonitor != null) {
            iExtendedDataElement2.addChild("waitMonitorKey", thd._waitMonitor.getName());
        }
        IExtendedDataElement iExtendedDataElement3 = iExtendedDataElement2.addChildWithIntValue("StackEntries", thd.getStkSize());
        IExtendedDataElement iExtendedDataElement4 = iExtendedDataElement2.addChildWithIntValue("StackEntriesNative", thd.getStkNativeSize());
        this.addStackEntries(thd, iExtendedDataElement3);
        this.addStackEntriesNative(thd, iExtendedDataElement4);
        return iExtendedDataElement2;
    }

    private ICommonBaseEvent createThreadCbe(ICommonBaseEvent iCommonBaseEvent, Thd thd, int n, Vector vector) {
        ICommonBaseEvent iCommonBaseEvent2 = this.createCBE("Thread" + n, iCommonBaseEvent, vector);
        iCommonBaseEvent2.addExtendedDataElementWithIntValue("Thread Index", n);
        iCommonBaseEvent2.addExtendedDataElement("threadId", thd.getThreadId());
        iCommonBaseEvent2.addExtendedDataElement("name", thd.getName());
        iCommonBaseEvent2.addExtendedDataElement("priority", thd._priority);
        iCommonBaseEvent2.addExtendedDataElement("state", thd._state);
        iCommonBaseEvent2.addExtendedDataElementWithIntValue("waitMonitorID", thd.getWaitMonitorId());
        if (thd._waitMonitor != null) {
            iCommonBaseEvent2.addExtendedDataElement("waitMonitorKey", thd._waitMonitor.getName());
        }
        IExtendedDataElement iExtendedDataElement = iCommonBaseEvent2.addExtendedDataElementWithIntValue("StackEntries", thd.getStkSize());
        IExtendedDataElement iExtendedDataElement2 = iCommonBaseEvent2.addExtendedDataElementWithIntValue("StackEntriesNative", thd.getStkNativeSize());
        this.addStackEntries(thd, iExtendedDataElement);
        this.addStackEntriesNative(thd, iExtendedDataElement2);
        return iCommonBaseEvent2;
    }

    private void addStackEntries(Thd thd, IExtendedDataElement iExtendedDataElement) {
        int n = 0;
        while (n < thd.getStkSize()) {
            StkEntry stkEntry = thd.getStkEntry(n);
            IExtendedDataElement iExtendedDataElement2 = iExtendedDataElement.addChildWithIntValue("StkEntry_" + n, n);
            iExtendedDataElement2.addChild("module", stkEntry._module);
            iExtendedDataElement2.addChild("pkg", stkEntry._pkg);
            iExtendedDataElement2.addChild("method", stkEntry._method);
            iExtendedDataElement2.addChildWithIntValue("lineno", stkEntry._lineno);
            iExtendedDataElement2.addChildWithBooleanValue("isNative", stkEntry._isNative);
            ++n;
        }
    }

    private void addStackEntriesNative(Thd thd, IExtendedDataElement iExtendedDataElement) {
        int n = 0;
        while (n < thd.getStkNativeSize()) {
            StkEntryNative stkEntryNative = thd.getStkEntryNative(n);
            IExtendedDataElement iExtendedDataElement2 = iExtendedDataElement.addChildWithIntValue("StkEntryNative_" + n, n);
            iExtendedDataElement2.addChild("function", stkEntryNative._function);
            iExtendedDataElement2.addChild("hexAddress", stkEntryNative._hexAddress);
            ++n;
        }
    }

    private void addMonitors(DumpData dumpData, IExtendedDataElement iExtendedDataElement, ICommonBaseEvent iCommonBaseEvent, Vector vector) {
        Monitor monitor;
        int n = 0;
        iCommonBaseEvent.addExtendedDataElementWithIntValue("Monitor Count", dumpData.getMonitors().size());
        Enumeration enumeration = dumpData.getMonitorEnum();
        while ((monitor = dumpData.getNextMonitor(enumeration)) != null) {
            this.createMonitorCbe(iCommonBaseEvent, monitor, n, vector);
            ++n;
        }
    }

    private void createMonitorXde(IExtendedDataElement iExtendedDataElement, Monitor monitor, int n) {
        IExtendedDataElement iExtendedDataElement2 = iExtendedDataElement.addChildWithIntValue("Monitor" + n, n);
        int n2 = monitor._waiters.size();
        iExtendedDataElement2.addChild("name", monitor.getName());
        if (monitor._owner != null) {
            iExtendedDataElement2.addChild("ownerThreadId", monitor._owner._threadId);
            iExtendedDataElement2.addChild("ownerThreadName", monitor._owner.getName());
        }
        iExtendedDataElement2.addChildWithIntValue("monitor_type", monitor._monitor_type);
        if (n2 > 0) {
            IExtendedDataElement iExtendedDataElement3 = iExtendedDataElement2.addChildWithIntValue("Waiters", n2);
            this.addWaiters(monitor, iExtendedDataElement3);
        }
    }

    private void createMonitorCbe(ICommonBaseEvent iCommonBaseEvent, Monitor monitor, int n, Vector vector) {
        ICommonBaseEvent iCommonBaseEvent2 = this.createCBE("Monitor" + n, iCommonBaseEvent, vector);
        int n2 = monitor._waiters.size();
        iCommonBaseEvent2.addExtendedDataElementWithIntValue("Monitor Index", n);
        iCommonBaseEvent2.addExtendedDataElement("name", monitor.getName());
        if (monitor._owner != null) {
            iCommonBaseEvent2.addExtendedDataElement("ownerThreadId", monitor._owner._threadId);
            iCommonBaseEvent2.addExtendedDataElement("ownerThreadName", monitor._owner.getName());
        }
        iCommonBaseEvent2.addExtendedDataElementWithIntValue("monitor_type", monitor._monitor_type);
        if (n2 > 0) {
            IExtendedDataElement iExtendedDataElement = iCommonBaseEvent2.addExtendedDataElementWithIntValue("Waiters", n2);
            this.addWaiters(monitor, iExtendedDataElement);
        }
    }

    private void addWaiters(Monitor monitor, IExtendedDataElement iExtendedDataElement) {
        Vector vector = monitor._waiters;
        int n = monitor._waiters.size();
        int n2 = 0;
        while (n2 < n) {
            Thd thd = (Thd)vector.elementAt(n2);
            IExtendedDataElement iExtendedDataElement2 = iExtendedDataElement.addChildWithIntValue("Waiter_" + n2, n2);
            iExtendedDataElement2.addChild("ThreadId", thd.getThreadId());
            iExtendedDataElement2.addChild("ThreadName", thd.getName());
            ++n2;
        }
    }

    public ThreadDumpProcessorImpl() {
        String string = null;
        this._simpleEventFactory = SimpleEventFactoryImpl.getInstance();
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        try {
            IReportSituation iReportSituation = this._simpleEventFactory.createReportSituation();
            iReportSituation.setReportCategory("Trace");
            this._situation = EventItemsFactory.createISituation((String)"ReportSituation", (ISituationType)iReportSituation);
            this._compId = EventItemsFactory.createIComponentIdentification((String)"ProductName", (String)"Dummy", (String)"Thread/Monitor dump", (String)"Hostname", (String)string, null, null, null, null, null, (String)"JAVA JVM");
            this._associationEngine = this._simpleEventFactory.createAssociationEngine();
            this._associationEngine.setType("Root");
            this._associationEngine.setName("Root");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

