/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.LoggingParsersPlugin;

public final class ParserUtilities {
    private static ResourceBundle resourceBundle = null;
    static /* synthetic */ Class class$org$eclipse$hyades$logging$parsers$LoggingParsersPlugin;

    public static String getResourceString(String key) {
        if (key != null) {
            if (resourceBundle == null) {
                try {
                    resourceBundle = LoggingParsersPlugin.getResourceBundle();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (resourceBundle == null) {
                    try {
                        resourceBundle = ResourceBundle.getBundle("org.eclipse.hyades.logging.parsers.properties.plugin", Locale.getDefault());
                    }
                    catch (MissingResourceException m) {
                        return key;
                    }
                }
            }
            try {
                return resourceBundle.getString(key.trim()).trim();
            }
            catch (MissingResourceException m) {
            }
        }
        return key;
    }

    public static String getResourceString(String key, String argument) {
        return ParserUtilities.getResourceString(key, new String[]{argument});
    }

    public static String getResourceString(String key, String argumentA, String argumentB) {
        return ParserUtilities.getResourceString(key, new String[]{argumentA, argumentB});
    }

    public static String getResourceString(String key, String argumentA, String argumentB, String argumentC) {
        return ParserUtilities.getResourceString(key, new String[]{argumentA, argumentB, argumentC});
    }

    public static String getResourceString(String key, String[] arguments) {
        try {
            return MessageFormat.format(ParserUtilities.getResourceString(key), arguments);
        }
        catch (Exception e) {
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceString(String key, Locale locale) {
        block17: {
            if (key != null) {
                Locale defaultLocale = Locale.getDefault();
                if (locale != null && !locale.equals(defaultLocale)) {
                    ResourceBundle localeResourceBundle = null;
                    try {
                        Class clazz = class$org$eclipse$hyades$logging$parsers$LoggingParsersPlugin == null ? (class$org$eclipse$hyades$logging$parsers$LoggingParsersPlugin = ParserUtilities.class$("org.eclipse.hyades.logging.parsers.LoggingParsersPlugin")) : class$org$eclipse$hyades$logging$parsers$LoggingParsersPlugin;
                        synchronized (clazz) {
                            Locale.setDefault(locale);
                            try {
                                localeResourceBundle = LoggingParsersPlugin.getResourceBundle();
                                return localeResourceBundle;
                            }
                            catch (Throwable throwable) {
                                Object var7_10 = null;
                                Locale.setDefault(defaultLocale);
                                throw throwable;
                            }
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (localeResourceBundle == null || !localeResourceBundle.getLocale().equals(locale)) {
                        try {
                            localeResourceBundle = ResourceBundle.getBundle("org.eclipse.hyades.logging.parsers.properties.plugin", locale);
                        }
                        catch (MissingResourceException m) {
                            return ParserUtilities.getResourceString(key);
                        }
                    }
                    try {
                        return localeResourceBundle.getString(key.trim()).trim();
                    }
                    catch (MissingResourceException m) {
                        break block17;
                    }
                }
                return ParserUtilities.getResourceString(key);
            }
        }
        return key;
    }

    public static String getResourceString(String key, Locale locale, String argument) {
        return ParserUtilities.getResourceString(key, locale, new String[]{argument});
    }

    public static String getResourceString(String key, Locale locale, String argumentA, String argumentB) {
        return ParserUtilities.getResourceString(key, locale, new String[]{argumentA, argumentB});
    }

    public static String getResourceString(String key, Locale locale, String argumentA, String argumentB, String argumentC) {
        return ParserUtilities.getResourceString(key, locale, new String[]{argumentA, argumentB, argumentC});
    }

    public static String getResourceString(String key, Locale locale, String[] arguments) {
        try {
            return MessageFormat.format(ParserUtilities.getResourceString(key, locale), arguments);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static void exceptionHandler(Throwable throwable, long faultyLineNum, String faultyLine, String message) throws LogParserException {
        StringBuffer finalMsg = new StringBuffer(ParserUtilities.getResourceString("INVALID_LINE_NUMBER_ERROR_", String.valueOf(faultyLineNum)));
        String lineSep = Constants.LINE_SEPARATOR;
        finalMsg.append(':').append(lineSep).append(lineSep).append(faultyLine).append(lineSep);
        String errorMsg = null;
        if (throwable != null) {
            errorMsg = throwable.getMessage();
        }
        if (errorMsg != null && errorMsg.length() > 0) {
            finalMsg.append(errorMsg).append(lineSep);
        }
        finalMsg.append(message);
        LogParserException lpe = new LogParserException(finalMsg.toString(), throwable);
        lpe.fillInStackTrace();
        throw lpe;
    }

    public static void exceptionHandler(Throwable throwable, String message) throws LogParserException {
        String lineSep = Constants.LINE_SEPARATOR;
        StringBuffer finalMsg = new StringBuffer();
        if (throwable != null && throwable.getMessage() != null && throwable.getMessage().length() > 0) {
            finalMsg.append(throwable.getMessage()).append(lineSep);
        }
        finalMsg.append(message);
        LogParserException lpe = new LogParserException(finalMsg.toString(), throwable);
        lpe.fillInStackTrace();
        throw lpe;
    }

    public static boolean isValidIPAddress(String ipAddress) {
        block3: {
            StringTokenizer tokens = new StringTokenizer(ipAddress, ".", true);
            if (tokens.countTokens() != 7) break block3;
            try {
                int number = Integer.parseInt(tokens.nextToken());
                if (number >= 0 && number <= 255 && tokens.nextToken().equals(".") && (number = Integer.parseInt(tokens.nextToken())) >= 0 && number <= 255 && tokens.nextToken().equals(".") && (number = Integer.parseInt(tokens.nextToken())) >= 0 && number <= 255 && tokens.nextToken().equals(".") && (number = Integer.parseInt(tokens.nextToken())) >= 0 && number <= 255) {
                    return true;
                }
            }
            catch (NumberFormatException n) {}
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

