/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.remote;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import org.eclipse.hyades.execution.recorder.http.remote.HttpRecResourceBundle;
import org.eclipse.hyades.execution.recorder.http.remote.PacketWriter;

public class GlobalPacketQueue
extends Thread {
    static boolean NOTIFY_ON_ADD;
    static long PACKET_WAIT_TOLERANCE;
    protected PacketWriter packetWriter;
    protected boolean shuttingDown = false;
    protected long timeOfLastPackedAdd = 0L;
    protected LinkedList packetQueue = new LinkedList();

    public GlobalPacketQueue(PacketWriter packetWriter) {
        this.packetWriter = packetWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateShutdown() {
        this.shuttingDown = true;
        GlobalPacketQueue globalPacketQueue = this;
        synchronized (globalPacketQueue) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setName("PacketQueueWriter");
        while (!this.shuttingDown) {
            GlobalPacketQueue globalPacketQueue = this;
            synchronized (globalPacketQueue) {
                if (this.packetQueue.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.removeAndWrite();
            Thread.yield();
        }
        this.removeAndWrite();
    }

    protected void removeAndWrite() {
        Collection collection = this.removeAll();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                this.waitForInactivity();
                this.packetWriter.sendToDataProcessor(byArray);
                Thread.yield();
            }
        }
    }

    protected void waitForInactivity() {
        long l;
        long l2;
        long l3;
        while ((l3 = (l2 = this.timeOfLastPackedAdd) + PACKET_WAIT_TOLERANCE) > (l = System.currentTimeMillis())) {
            try {
                Thread.sleep(l3 - l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        GlobalPacketQueue globalPacketQueue = this;
        synchronized (globalPacketQueue) {
            this.packetQueue.addLast(byArray2);
            this.timeOfLastPackedAdd = System.currentTimeMillis();
            if (NOTIFY_ON_ADD) {
                this.notify();
            }
        }
    }

    public void add(String string) {
        byte[] byArray = string.getBytes();
        this.add(byArray, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection removeAll() {
        LinkedList linkedList = null;
        GlobalPacketQueue globalPacketQueue = this;
        synchronized (globalPacketQueue) {
            if (this.packetQueue.size() == 0) {
                linkedList = null;
            } else {
                linkedList = this.packetQueue;
                this.packetQueue = null;
                this.packetQueue = new LinkedList();
            }
        }
        return linkedList;
    }

    static {
        String string;
        NOTIFY_ON_ADD = false;
        PACKET_WAIT_TOLERANCE = 500L;
        try {
            string = HttpRecResourceBundle.getInstance().getString("RECORDER_NOTIFY_ON_ADD");
            if (string.compareToIgnoreCase("TRUE") == 0) {
                NOTIFY_ON_ADD = true;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        try {
            string = HttpRecResourceBundle.getInstance().getString("RECORDER_PACKET_WAIT_TOLERANCE");
            PACKET_WAIT_TOLERANCE = Long.parseLong(string);
        }
        catch (Exception exception) {}
    }
}

