/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.runner.ui.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.hyades.test.manual.runner.model.Action;
import org.eclipse.hyades.test.manual.runner.model.IActionOwner;
import org.eclipse.hyades.test.manual.runner.model.IVerdictListener;
import org.eclipse.hyades.test.manual.runner.model.NamedElement;
import org.eclipse.hyades.test.manual.runner.model.TestInvocation;
import org.eclipse.hyades.test.manual.runner.model.TestSuite;
import org.eclipse.hyades.test.manual.runner.model.util.ModelUtil;

public class TestSuiteTreeModel
implements TreeModel,
IVerdictListener {
    private List modelListeners;
    private JTree tree;

    public TestSuiteTreeModel() {
        TestInvocation.addListener(this);
        this.modelListeners = new ArrayList();
    }

    public void dispose() {
        this.modelListeners.clear();
        this.tree = null;
    }

    public void handleVerdict(TestInvocation testInvocation) {
        this.fireTreeNodesChanged(testInvocation, TestSuiteTreeModel.getTreePath(testInvocation).getPath(), null, null);
        this.select(ModelUtil.DEFAULT_EXECUTION_MANAGER.next());
    }

    public void select(NamedElement namedElement) {
        if (namedElement == null) {
            namedElement = ModelUtil.DEFAULT_EXECUTION_MANAGER.getRoot();
        }
        TreePath treePath = TestSuiteTreeModel.getTreePath(namedElement);
        this.getTree().setSelectionPath(treePath);
        this.getTree().scrollPathToVisible(treePath);
    }

    public static TreePath getTreePath(NamedElement namedElement) {
        if (namedElement == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        TestSuiteTreeModel.getTreePath(arrayList, namedElement);
        return new TreePath(arrayList.toArray());
    }

    private static void getTreePath(List list, Object object) {
        if (object == null) {
            return;
        }
        list.add(0, object);
        if (object instanceof Action) {
            TestSuiteTreeModel.getTreePath(list, ((Action)object).getOwner());
        } else if (object instanceof TestSuite) {
            TestSuiteTreeModel.getTreePath(list, ((TestSuite)object).getTestInvocation());
        }
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (treeModelListener != null && !this.modelListeners.contains(treeModelListener)) {
            this.modelListeners.add(treeModelListener);
        }
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.modelListeners.remove(treeModelListener);
    }

    public Object getChild(Object object, int n) {
        TestInvocation testInvocation;
        if (object instanceof IActionOwner) {
            return ((IActionOwner)object).getActions().get(n);
        }
        if (object instanceof TestInvocation && n == 0 && (testInvocation = (TestInvocation)object).getTest() != null && testInvocation.getTest() instanceof TestSuite) {
            return testInvocation.getTest();
        }
        return null;
    }

    public int getChildCount(Object object) {
        TestInvocation testInvocation;
        if (object instanceof IActionOwner) {
            return ((IActionOwner)object).getActions().size();
        }
        if (object instanceof TestInvocation && (testInvocation = (TestInvocation)object).getTest() != null && testInvocation.getTest() instanceof TestSuite) {
            return 1;
        }
        return 0;
    }

    public int getIndexOfChild(Object object, Object object2) {
        TestInvocation testInvocation;
        if (object instanceof IActionOwner) {
            return ((IActionOwner)object).getActions().indexOf(object2);
        }
        if (object instanceof TestInvocation && (testInvocation = (TestInvocation)object).getTest() == object2) {
            return 0;
        }
        return -1;
    }

    public Object getRoot() {
        return ModelUtil.DEFAULT_EXECUTION_MANAGER.getRoot();
    }

    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        Iterator iterator = this.modelListeners.iterator();
        while (iterator.hasNext()) {
            TreeModelListener treeModelListener = (TreeModelListener)iterator.next();
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    JTree getTree() {
        return this.tree;
    }

    void setTree(JTree jTree) {
        this.tree = jTree;
        jTree.setModel(this);
    }
}

