/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.IStatus;
import org.eclipse.hyades.logging.adapter.impl.Component;
import org.eclipse.hyades.logging.adapter.impl.Status;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.w3c.dom.Element;

public abstract class Context
extends Component
implements IContext {
    private boolean continuousOperation = false;
    private long maximumIdleTime = 0L;
    private long pauseInterval = 0L;
    private long pauseCount = 0L;
    private Locale locale;
    private String charset;
    private boolean hardStop = false;
    protected IContextListener listener;

    public void stop() {
        super.stop();
        this.listener = null;
        this.status.setActive(false);
    }

    public void resetControledStop() {
        this.resetPauseCount();
    }

    public void resetPauseCount() {
        this.pauseCount = 0L;
    }

    public void incrementPauseCount() {
        ++this.pauseCount;
    }

    public long getPauseCount() {
        return this.pauseCount;
    }

    public void setPauseCount(long newPauseCount) {
        this.pauseCount = newPauseCount;
    }

    public void setContinuousOperation(boolean newContinuousOperation) {
        this.continuousOperation = newContinuousOperation;
    }

    public boolean getContinuousOperation() {
        return this.continuousOperation;
    }

    public void setMaximumIdleTime(long newMaximumIdleTime) {
        this.maximumIdleTime = newMaximumIdleTime;
    }

    public long getMaximumIdleTime() {
        return this.maximumIdleTime;
    }

    public void setPauseInterval(long newPauseInterval) {
        this.pauseInterval = newPauseInterval;
    }

    public long getPauseInterval() {
        return this.pauseInterval;
    }

    public void update() throws AdapterInvalidConfig {
        this.status.setName(this.getName());
        Element element = this.getConfiguration();
        if (element.hasAttribute(Messages.getString("HyadesGAcontinuousOperationAttributeName"))) {
            this.setContinuousOperation(Boolean.valueOf(element.getAttribute(Messages.getString("HyadesGAcontinuousOperationAttributeName"))));
        }
        if (element.hasAttribute(Messages.getString("HyadesGApauseIntervalAttributeName"))) {
            this.setPauseInterval(Long.valueOf(element.getAttribute(Messages.getString("HyadesGApauseIntervalAttributeName"))));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAmaximumIdleTimeAttributeName"))) {
            this.setMaximumIdleTime(Long.valueOf(element.getAttribute(Messages.getString("HyadesGAmaximumIdleTimeAttributeName"))));
        }
        String isoLanguageCode = element.getAttribute(Messages.getString("HyadesGAISOLanguageCodeAttributeName"));
        String isoCountryCode = element.getAttribute(Messages.getString("HyadesGAISOCountryCodeAttributeName"));
        this.charset = element.getAttribute(Messages.getString("HyadesGACharsetAttributeName"));
        if ((isoLanguageCode == null || isoLanguageCode.equals("")) && (isoCountryCode == null || isoCountryCode.equals(""))) {
            this.locale = Locale.getDefault();
        } else {
            Locale[] supportedLocals = Locale.getAvailableLocales();
            int i = 0;
            while (i < supportedLocals.length) {
                if (isoLanguageCode != null && !isoLanguageCode.equals("")) {
                    if (isoLanguageCode.equals(supportedLocals[i].getLanguage())) {
                        if (isoCountryCode != null && !isoCountryCode.equals("")) {
                            if (supportedLocals[i].getCountry().equals(isoCountryCode)) {
                                this.locale = supportedLocals[i];
                                break;
                            }
                        } else {
                            this.locale = supportedLocals[i];
                        }
                    }
                } else if (supportedLocals[i].getCountry().equals(isoCountryCode)) {
                    this.locale = supportedLocals[i];
                    break;
                }
                ++i;
            }
        }
        if (this.locale == null) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_LocaleNotFound_ERROR_", isoLanguageCode, isoCountryCode));
        }
        this.setLocale(this.locale);
        CommonBaseEvent localeEvent = this.getEventFactory().createCommonBaseEvent();
        localeEvent.setMsg(Messages.getString("HyadesGAContextInstanceConfiguration_ContextLocaleSetting_INFO_", this.locale.getDisplayName()));
        localeEvent.setSeverity((short)10);
        this.log(localeEvent);
        if (this.charset == null || this.charset.equals("")) {
            this.charset = System.getProperty("os.name", "Windows").equals("z/OS") || System.getProperty("os.name", "Windows").equals("OS/390") ? "IBM-1047" : "UTF-8";
        }
        try {
            byte[] barr = this.charset.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfiguration_CharsetNotSupported_ERROR_", this.charset));
        }
        CommonBaseEvent charsetEvent = this.getEventFactory().createCommonBaseEvent();
        charsetEvent.setMsg(Messages.getString("HyadesGAContextInstanceConfiguration_ContextCharsetSetting_INFO_", this.charset));
        charsetEvent.setSeverity((short)10);
        this.log(charsetEvent);
        super.update();
        CommonBaseEvent configureEvent = this.getEventFactory().createCommonBaseEvent();
        configureEvent.setMsg(Messages.getString("HyadesGAContextInstanceConfiguration_ConfigurationComplete_INFO_", this.getName()));
        configureEvent.setSeverity((short)10);
        Situation configSituation = this.getEventFactory().createSituation();
        configSituation.setConfigureSituation("INTERNAL", "SUCCESSFUL");
        configureEvent.setSituation(configSituation);
        this.log(configureEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleControledStop() {
        if (!this.getContinuousOperation()) {
            this.hardStop = false;
            this.stop();
        } else if (this.getMaximumIdleTime() == 0L || this.getMaximumIdleTime() / this.getPauseInterval() >= this.getPauseCount()) {
            try {
                Context context = this;
                synchronized (context) {
                    Thread.sleep(this.getPauseInterval());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.incrementPauseCount();
        } else {
            this.hardStop = true;
            this.stop();
        }
    }

    public void setContextListener(IContextListener listener) {
        this.listener = listener;
    }

    public IContextListener getContextListener() {
        return this.listener;
    }

    protected boolean isHardStop() {
        return this.hardStop;
    }

    protected void setHardStop() {
        this.hardStop = true;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Status getContextStatus() {
        IComponent[] components;
        if (this.status.getChildrenStatus() == null && (components = this.getComponents()) != null) {
            IStatus[] statuses = new Status[components.length];
            int i = 0;
            while (i < components.length) {
                statuses[i] = ((Component)components[i]).getComponentStatus();
                ++i;
            }
            this.status.setChildrenStatus(statuses);
        }
        return this.status;
    }
}

