/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.ExecutionComponentStateException;
import org.eclipse.hyades.execution.core.IControlMessage;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.MessageDeliveryException;
import org.eclipse.hyades.execution.core.impl.IJavaTaskExecutableObject;
import org.eclipse.hyades.execution.core.impl.JavaTaskExecutorImpl;
import org.eclipse.hyades.execution.local.ExecutorStub;
import org.eclipse.hyades.execution.local.JavaTaskRemoteHyadesComponentStub;
import org.eclipse.hyades.execution.local.SessionImpl;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentImpl;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;

public class JavaTaskExecutorStub
extends ExecutorStub {
    private AgentImpl agent;
    private boolean isAgentActive;

    public JavaTaskExecutorStub() {
    }

    public JavaTaskExecutorStub(IExecutionComponent delegate) {
        super(delegate);
    }

    public void launch() throws ExecutionComponentStateException {
        if (!this.isAgentActive()) {
            StringBuffer buf = new StringBuffer();
            buf.append("The remote agent \"");
            buf.append(this.agent.getName());
            buf.append("\" is not active");
            throw new ExecutionComponentStateException(1, buf.toString());
        }
        super.launch();
    }

    public IExecutableObject getCompatibleExecutableObject(String classname) throws ClassNotFoundException {
        IExecutableObject exeObj = super.getCompatibleExecutableObject(classname);
        if (!(exeObj instanceof IJavaTaskExecutableObject)) {
            throw new ClassCastException("Component factory returned an incorrect type; expected an IJavaTaskExecutableObject");
        }
        return exeObj;
    }

    public void init() {
        super.init();
        SessionImpl session = (SessionImpl)((Object)((SessionStub)this.getSessionContext()).getDelegate());
        this.agent = (AgentImpl)AgentFactory.createAgent(session.getAgent().getProcess(), "Executor$" + this.getUniqueId(), "tester");
        this.agent.setAutoAttach(true);
        this.agent.addAgentListener(new AgentListener(){

            public void agentActive(Agent agent) {
                JavaTaskExecutorStub.this.setAgentActive(true);
                JavaTaskExecutorStub.this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)JavaTaskExecutorStub.this, 2));
            }

            public void agentInactive(Agent agent) {
                JavaTaskExecutorStub.this.setAgentActive(false);
                JavaTaskExecutorStub.this.fireStateChangeEvent(new ExecutionComponentStateChangeEvent((IExecutionComponent)JavaTaskExecutorStub.this, 4));
            }

            public void error(Agent agent, String errorId, String errorMessage) {
                StringBuffer buf = new StringBuffer();
                buf.append("ERROR: Agent \"");
                buf.append(agent.getName());
                buf.append("\"\nERROR ID: \"");
                buf.append(errorId);
                buf.append("\"\nERROR MESSAGE: \"");
                buf.append(errorMessage);
                buf.append("\"\n");
                System.err.println(buf.toString());
            }

            public void handleCommand(Agent agent, CommandElement command) {
                System.out.println(agent.getName() + " handleCommand() called");
            }
        });
        ((JavaTaskExecutorImpl)this.delegate).init();
    }

    public void sendMessage(IControlMessage message) throws MessageDeliveryException {
        CustomCommand startCmd = new CustomCommand();
        startCmd.setData(message.getMessageData());
        try {
            this.agent.invokeCustomCommand(startCmd);
        }
        catch (InactiveAgentException e) {
            throw new MessageDeliveryException((Throwable)new ExecutionComponentStateException(1, "The monitoring agent is not active"));
        }
    }

    private synchronized void setAgentActive(boolean active) {
        this.isAgentActive = active;
    }

    private synchronized boolean isAgentActive() {
        return this.isAgentActive;
    }

    public void addChild(IExecutionComponent child) {
        if (child instanceof JavaTaskRemoteHyadesComponentStub) {
            ((JavaTaskRemoteHyadesComponentStub)child).setAgent(this.agent);
        }
        super.addChild(child);
    }

    public boolean supportsControlEvent(String controlEvent) {
        return false;
    }

    public String performControlEvent(String controlEvent, String[] params) {
        return "";
    }
}

