/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DirectedGraph;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.Monitor;
import org.eclipse.hyades.collection.threadanalyzer.ParseIdents;
import org.eclipse.hyades.collection.threadanalyzer.ParseMonitorOwner;
import org.eclipse.hyades.collection.threadanalyzer.ParseSystemMonitor;
import org.eclipse.hyades.collection.threadanalyzer.ParseTID;
import org.eclipse.hyades.collection.threadanalyzer.ThreadDump;

public class DeadLockDetect {
    private DirectedGraph theGraph = null;
    private Hashtable _threads = null;
    private Hashtable _ownedMonitors = null;
    private Hashtable _sysMon = null;
    private Hashtable _tid = null;
    private Hashtable _monitors = null;
    private Hashtable _idents = null;
    private ThreadDump _threadDump = null;
    private Vector _threadDumpLines = null;
    private DumpData _dumpData = null;
    private boolean doesDeadlockExist = false;
    private Vector deadlockResult = null;
    private int _logLevel = -1;

    public DeadLockDetect(DumpData dumpData) {
        this._dumpData = dumpData;
        this._monitors = dumpData.getMonitors();
        this._threads = dumpData.getThreads();
        this._threadDump = dumpData.getThreadDump();
        this._threadDumpLines = this._dumpData.getThreadDump().getThreadDumpVector();
        this._idents = null;
        this._ownedMonitors = null;
        this._sysMon = null;
        this.theGraph = new DirectedGraph(this._threads);
    }

    public DeadLockDetect(DumpData dumpData, String string) {
        this(dumpData);
        if (string.equalsIgnoreCase("DEBUG")) {
            this.setLogLevel(4);
        } else {
            this.setLogLevel(3);
        }
    }

    protected void collectData() {
        int n = DeadLockDetect.getLocation(this._threadDumpLines, 0, "Monitor Pool Dump (");
        this.logDebug("MonitorPoolDump@" + n);
        int n2 = DeadLockDetect.getLocation(this._threadDumpLines, n, "JVM System Monitor Dump (registered monitors):");
        this.logDebug("JVMSysMon@" + n2);
        int n3 = DeadLockDetect.getLocation(this._threadDumpLines, n2, "Thread identifiers (as used in flat monitors):");
        this.logDebug("identIndex@" + n3);
        this.logDebug("Populating Idents");
        ParseIdents parseIdents = new ParseIdents(this._threadDump, this._threads);
        parseIdents.populate(n3);
        this._idents = parseIdents.getIdents();
        this.logDebug("idents Populated");
        this.logDebug("Populating TID");
        ParseTID parseTID = new ParseTID(this._threadDumpLines);
        parseTID.doIt();
        this._tid = parseTID.getTIDMap();
        this.theGraph.putReversedTid(parseTID.getReversedTIDMap());
        this.logDebug("TID populated");
        this.logDebug("Populating Monitor Owner");
        ParseMonitorOwner parseMonitorOwner = new ParseMonitorOwner(this._idents, this._threads, this._monitors, this._tid, this._threadDump);
        parseMonitorOwner.doIt(n);
        this.logDebug("Monitor owner populated");
        this.logDebug("Populating system monitors");
        ParseSystemMonitor parseSystemMonitor = new ParseSystemMonitor(this._threads, this._idents, this._threadDumpLines);
        parseSystemMonitor.doIt(n2, n3);
        this.logDebug("system monitors populated");
        this._ownedMonitors = parseMonitorOwner.getOwnedMonitors();
        this._sysMon = parseSystemMonitor.getSysMon();
        this.logDebug("building directed graph for deadlock detection");
        this.buildDirectedGraph();
        this.logDebug("directed graph built");
    }

    protected void buildDirectedGraph() {
        int n;
        Iterator iterator = this._threads.keySet().iterator();
        while (iterator.hasNext()) {
            this.theGraph.addVertex(this._threads.get(iterator.next()));
        }
        iterator = this._ownedMonitors.keySet().iterator();
        Monitor monitor = null;
        while (iterator.hasNext()) {
            monitor = (Monitor)this._ownedMonitors.get(iterator.next());
            n = 0;
            while (n < monitor._waiters.size()) {
                this.theGraph.addEdge(monitor, monitor._owner, monitor._waiters.get(n));
                ++n;
            }
        }
        iterator = this._sysMon.keySet().iterator();
        while (iterator.hasNext()) {
            monitor = (Monitor)this._sysMon.get(iterator.next());
            n = 0;
            while (n < monitor._waiters.size()) {
                this.theGraph.addEdge(monitor, monitor._owner, monitor._waiters.get(n));
                ++n;
            }
        }
    }

    public void doIt() {
        this.collectData();
        this.theGraph.findCircularPattern();
        this.logDebug("finding/looking for circular pattern");
        this.deadlockResult = this.theGraph.getNotNullPairs();
        this.doesDeadlockExist = this.theGraph.getDeadlockExists();
    }

    public Vector getResults() {
        return this.deadlockResult;
    }

    public void copyIt(String string, String string2) {
        Vector vector = this._threadDump.getThreadDumpVector();
        this.deadlockResult = new Vector(100);
        String string3 = null;
        int n = 0;
        block0: while (n < vector.size()) {
            string3 = (String)vector.get(n);
            if (string3.indexOf(string) != -1) {
                this.doesDeadlockExist = true;
                int n2 = n;
                while (n2 < vector.size()) {
                    string3 = (String)vector.get(n2);
                    if ((string3 = string3.substring(string3.indexOf(":") + 1, string3.length())).indexOf(string2) != -1) break block0;
                    this.deadlockResult.add(string3);
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (!this.doesDeadlockExist) {
            this.deadlockResult = null;
        }
    }

    public static final int getLocation(Vector vector, int n, String string) {
        int n2 = 0;
        int n3 = vector.size();
        n2 = n;
        while (n2 < n3) {
            if (((String)vector.elementAt(n2)).indexOf(string) >= 0) break;
            ++n2;
        }
        return n2;
    }

    public boolean getDeadlockExists() {
        return this.doesDeadlockExist;
    }

    public void setLogLevel(int n) {
        this._logLevel = n;
    }

    public void logDebug(String string) {
        if (this._logLevel >= 4) {
            System.err.println("DEBUG: " + string);
        }
    }
}

