/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.internal.GraphDrawStrategy;
import org.eclipse.hyades.trace.views.internal.JCanvas;
import org.eclipse.hyades.trace.views.internal.SinglePattern;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class SinglePatternDrawStrategy
extends GraphDrawStrategy
implements KeyListener {
    public static final String ZOOM_IN = "+";
    public static final String ZOOM_OUT = "-";
    protected final float MAG_STEP = 2.0f;
    private final int PREF_TREE_WIDTH = 1000;
    private String tmpString;
    private SinglePattern _parent;
    private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt("time_display");
    private int _indexOfInvocation = 0;
    private TRCFullMethodInvocation _viewroot;
    private int _treewidth;
    private long _maxtime = 0L;
    private float timescale = 1.0f;
    private boolean _hidedetails = true;
    protected static final int NRLABELS = 10;
    protected static final int MAXINV = 256;
    private TRCMethodInvocation[] _drawArray = new TRCMethodInvocation[256];
    private float[] _x = new float[256];
    private float[] _y = new float[256];
    private float[] _w = new float[256];
    private float[] _h = new float[256];
    private float _canvasVisibleBottom;
    private float _canvasVisibleTop;
    private float _canvasVisibleLeft;
    private float _canvasVisibleRight;
    private ArrayList _calleeList = new ArrayList();

    public SinglePatternDrawStrategy(SinglePattern parent) {
        this._parent = parent;
        this.setNonPropZoom(true);
    }

    public void bgRedraw(GC gc) {
        try {
            JCanvas c = this.jcanvas();
            if (c == null || this._viewroot == null) {
                return;
            }
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            this._canvasVisibleBottom = c.visibleBottom();
            this._canvasVisibleTop = c.visibleTop();
            this._canvasVisibleLeft = c.visibleLeft();
            this._canvasVisibleRight = c.visibleRight();
            this._hidedetails = true;
            this.initDrawArray();
            this.drawTree(gc, (TRCMethodInvocation)this._viewroot, 0, this.cellWidth(), this.titleMargin() - (int)((float)TString.getTime((double)this._viewroot.getEntryTime()) * this.timescale));
            this.flushDrawArray(gc);
            this._hidedetails = false;
            this.initDrawArray();
            this.drawTree(gc, (TRCMethodInvocation)this._viewroot, 0, this.cellWidth(), this.titleMargin() - (int)((float)TString.getTime((double)this._viewroot.getEntryTime()) * this.timescale));
            this.flushDrawArray(gc);
            this.drawTimeMarks(gc, 0, 0);
        }
        catch (StackOverflowError exc) {}
    }

    protected int cellHeight() {
        return 20;
    }

    protected int cellWidth() {
        return 20;
    }

    public int current() {
        return this._indexOfInvocation + 1;
    }

    protected void drawInvocation(GC gc, TRCMethodInvocation inv, float x, float y, float w, float h, boolean showString) {
        JCanvas c = this.jcanvas();
        if (c == null) {
            return;
        }
        float yscale = c.yscale();
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        String msg = inv.getMethod().getName();
        Color colmsg = display.getSystemColor(2);
        if ((inv.getMethod().getModifier() & 0x80) != 0) {
            colmsg = display.getSystemColor(3);
        }
        TRCTraceObject o = inv.getOwningObject();
        String clss = PerftraceUtil.getClass(inv).getName();
        Color col = SpectrumColorMap.color(clss);
        double scale = c.xscale();
        if (showString && scale > 0.5 && !this._hidedetails) {
            int maxchars = (int)((double)w * scale / 5.0);
            if (msg.length() > maxchars) {
                msg = msg.substring(0, maxchars);
            }
            float fontheight = (float)gc.getFontMetrics().getHeight() / yscale;
            c.drawString(gc, msg, x, y + fontheight, colmsg);
        }
        if (scale * (double)w > 20.0) {
            c.drawLine(gc, x, y, x + 3.0f * w / 4.0f, y, colmsg);
            c.fillRect(gc, x + 3.0f * w / 4.0f, y, w / 4.0f, h, col);
        } else {
            c.fillRect(gc, x + w / 4.0f, y, w * 3.0f / 4.0f, h, col);
        }
    }

    protected void drawNextPattern() {
        if (this._viewroot != null && this._viewroot.getMethod().getInvocations().size() > 0) {
            this._viewroot = (TRCFullMethodInvocation)this._viewroot.getMethod().getInvocations().get(++this._indexOfInvocation);
        } else {
            this._viewroot = null;
            this._indexOfInvocation = 0;
        }
        this.setTitle();
        this._parent.updateButtons();
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    protected void setTitle() {
        StringBuffer buffer = new StringBuffer();
        if (this._viewroot == null) {
            this.tmpString = "";
        } else {
            TRCMethod method = this._viewroot.getMethod();
            if (method != null) {
                this.tmpString = TraceUIPlugin.getString("METHOD_A");
                this.tmpString = TString.change((String)this.tmpString, (String)"%1", (String)(method.getDefiningClass().getName() + "." + method.getName() + method.getSignature()));
            }
            buffer.append(this.tmpString).append(" : ").append(this._indexOfInvocation + 1).append("/").append(method.getInvocations().size());
        }
        this._parent.updateTitle(buffer.toString());
    }

    protected void drawPattern(int i) {
        this._viewroot = (TRCFullMethodInvocation)this._viewroot.getMethod().getInvocations().get(i);
        this._indexOfInvocation = i;
        this.setTitle();
        this._parent.updateButtons();
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    protected void drawPreviousPattern() {
        this._viewroot = (TRCFullMethodInvocation)this._viewroot.getMethod().getInvocations().get(--this._indexOfInvocation);
        this.setTitle();
        this._parent.updateButtons();
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    protected void drawTimeMarks(GC gc, int offx, int offy) {
        JCanvas c = this.jcanvas();
        if (this.isDirty() || c == null) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        float margin = 50.0f / c.xscale();
        float rightvis = c.visibleRight();
        long toptime = (long)((c.visibleTop() - (float)this.titleMargin()) / this.timescale);
        long heighttime = (long)(c.visibleHeight() / this.timescale);
        long interval = heighttime / 10L;
        float x = rightvis - margin;
        float fontheight = (float)gc.getFontMetrics().getHeight() / c.yscale();
        if (interval > 1L) {
            long niceinterval = (long)Math.pow(10.0, (int)(Math.log(interval) / Math.log(10.0)) + 1) / 2L;
            long newtoptime = niceinterval * (toptime / niceinterval + 1L);
            int i = 0;
            while (i < 20) {
                long timemark = newtoptime + (long)i * niceinterval;
                float y = (float)timemark * this.timescale + (float)this.titleMargin();
                c.drawString(gc, PerftraceUtil.formatTimeValue((double)timemark / 1000000.0), (float)offx + x, (float)offy + y, display.getSystemColor(2), display.getSystemColor(15));
                ++i;
            }
        }
        c.drawString(gc, TraceUIPlugin.getString("STR_GRAPH_UNIT"), (float)offx + x - 20.0f, c.visibleTop() + fontheight, display.getSystemColor(2), display.getSystemColor(15));
    }

    protected void drawTree(GC gc, TRCMethodInvocation invocation, int depth, float offx, float offy) {
        ITraceSelection model;
        JCanvas canvas = this.jcanvas();
        if (invocation == null || !(invocation instanceof TRCFullMethodInvocation) || canvas == null || this.isDirty()) {
            return;
        }
        TRCFullMethodInvocation inv = (TRCFullMethodInvocation)invocation;
        long start = PerftraceUtil.getTime(inv.getEntryTime());
        long end = PerftraceUtil.getTime(inv.getExitTime());
        if (end <= 0L) {
            end = this.maxTime();
        }
        if (offy + (float)start * this.timescale > this._canvasVisibleBottom || offy + (float)end * this.timescale < this._canvasVisibleTop) {
            return;
        }
        float height = (float)(end - start) * this.timescale;
        if (this._hidedetails && canvas.yscale() * height < 10.0f) {
            return;
        }
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if ((model = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject())).contains((Object)inv) || model.contains((Object)inv.getMethod())) {
            float fontheight = (float)gc.getFontMetrics().getHeight() / canvas.yscale();
            canvas.fill3DRect(gc, offx + (float)(4 * depth * this.cellWidth()), offy + (float)start * this.timescale, this.treeWidth() - (4 * depth + 2) * this.cellWidth(), Math.max(height, fontheight), SpectrumColorMap.getSelectionColor());
        } else if (model.contains((Object)inv.getOwningObject())) {
            canvas.fill3DRect(gc, offx + (float)((4 * depth + 3) * this.cellWidth()) - 5.0f, offy + (float)start * this.timescale, (float)(this.treeWidth() - (4 * depth + 5) * this.cellWidth()) + 5.0f, height, SpectrumColorMap.getSelectionColor());
        }
        if (offx + (float)((depth + 1) * this.cellWidth() * 4) < this._canvasVisibleRight) {
            Object[] segments = inv.getInvokes().toArray();
            int i = 0;
            while (i < segments.length) {
                TRCFullMethodInvocation kid = (TRCFullMethodInvocation)segments[i];
                if ((float)PerftraceUtil.getTime(kid.getEntryTime()) * this.timescale * offy > this._canvasVisibleBottom) break;
                long kidend = PerftraceUtil.getTime(kid.getExitTime());
                if (kidend <= 0L) {
                    kidend = this.maxTime();
                }
                if (!((float)kidend * this.timescale + offy < this._canvasVisibleTop)) {
                    this.drawTree(gc, (TRCMethodInvocation)kid, depth + 1, offx, offy);
                }
                ++i;
            }
        }
        if (depth < 256) {
            this.push(gc, depth, (TRCMethodInvocation)inv, offx + (float)(depth * this.cellWidth() * 4), offy + (float)start * this.timescale, this.cellWidth() * 4, height);
        } else {
            this.drawInvocation(gc, (TRCMethodInvocation)inv, offx + (float)(depth * this.cellWidth() * 4), offy + (float)start * this.timescale, this.cellWidth() * 4, height, true);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
    }

    protected void flushDrawArray(GC gc) {
        int i = 0;
        while (i < 256) {
            if (this._drawArray[i] != null) {
                this.drawInvocation(gc, this._drawArray[i], this._x[i], this._y[i], this._w[i], this._h[i], true);
            }
            ++i;
        }
    }

    public boolean hasCaller() {
        return this._viewroot != null && this._viewroot.getInvokedBy() != null;
    }

    public boolean hasCallee() {
        return this._calleeList.size() > 0;
    }

    public boolean hasLessElements() {
        return this._indexOfInvocation > 0;
    }

    public boolean hasMoreElements() {
        return this._viewroot != null && this._indexOfInvocation < this._viewroot.getMethod().getInvocations().size() - 1;
    }

    public float height() {
        if (this._viewroot != null) {
            return (float)(this.maxTime() - PerftraceUtil.getTime(this._viewroot.getEntryTime())) * this.timescale + (float)this.titleMargin() + (float)this.cellWidth();
        }
        return this.titleMargin() + this.cellWidth();
    }

    protected void initDrawArray() {
        int i = 0;
        while (i < 256) {
            this._drawArray[i] = null;
            this._h[i] = 0.0f;
            this._w[i] = 0.0f;
            this._y[i] = 0.0f;
            this._x[i] = 0.0f;
            ++i;
        }
    }

    public boolean isSearchable() {
        return UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject()).size() > 0;
    }

    public void keyPressed(KeyEvent e) {
        JCanvas canvas = this.jcanvas();
        if (canvas == null) {
            return;
        }
        if (e.keyCode == 262144) {
            this._controlDown = true;
        } else if (e.keyCode == 0x1000007) {
            canvas.zoomToFill(1.0f, 1000.0f);
        } else {
            float x = canvas.normX(canvas.getSize().width / 2);
            float y = canvas.normY(canvas.getSize().height / 2);
            if (e.character == ',' || e.character == '<') {
                canvas.zoom(1.0f, 0.5f, x, y);
            } else if (e.character == '.' || e.character == '>') {
                canvas.zoom(1.0f, 2.0f, x, y);
            }
        }
    }

    protected int maxDepth() {
        if (this._viewroot != null) {
            return this._viewroot.getStackDepth();
        }
        return 0;
    }

    protected long maxTime() {
        long largestTime = 0L;
        if (this._viewroot != null && (largestTime = PerftraceUtil.getTime(this._viewroot.getExitTime())) == 0L) {
            largestTime = PerftraceUtil.getTime(this._viewroot.getOwningObject().getProcess().getLastEventTime());
        }
        return largestTime;
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 3) {
            return;
        }
        super.mouseDown(e);
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 3) {
            return;
        }
        super.mouseUp(e);
    }

    public void moved(float x, float y) {
        if (this._viewroot == null) {
            return;
        }
        TRCFullMethodInvocation selinv = this.subtreeContains(this._viewroot, x - (float)this.cellWidth(), y + (float)((int)((float)PerftraceUtil.getTime(this._viewroot.getEntryTime()) * this.timescale)), 0);
        if (selinv != null) {
            TRCTraceObject obj = selinv.getOwningObject();
            String implname = selinv.getMethod().getDefiningClass().getName();
            String msgname = selinv.getMethod().getName();
            String objclname = PerftraceUtil.getClass((TRCMethodInvocation)selinv).getName();
            double time = selinv.getExitTime();
            if (time == 0.0) {
                time = obj.getProcess().getLastEventTime();
            }
            String statusMsg = TraceUIPlugin.getString("A_ON_B_AT_C_TIME");
            if (this._drawMode == 1) {
                statusMsg = TraceUIPlugin.getString("A_ON_B_AT_RAW_TIME");
            }
            statusMsg = TString.change((String)statusMsg, (String)"%1", (String)(implname + "." + msgname));
            statusMsg = TString.change((String)statusMsg, (String)"%2", (String)(objclname + "." + obj.getId()));
            statusMsg = TString.change((String)statusMsg, (String)"%3", (String)TString.formatTimeValue((double)selinv.getEntryTime()));
            double raw = time - selinv.getEntryTime();
            double compensated = raw - selinv.getOverhead();
            statusMsg = TString.change((String)statusMsg, (String)"%4", (String)TString.formatTimeValue((double)(this._drawMode == 1 ? raw : compensated)));
            this.status(statusMsg);
        } else {
            long tm = (long)((y - (float)this.titleMargin()) / this.timescale);
            String statusMsg = TraceUIPlugin.getString("TIME_X");
            statusMsg = TString.change((String)statusMsg, (String)"%1", (String)TString.formatTimeValue((double)((double)tm / 1000000.0)));
            this.status(statusMsg);
        }
    }

    protected void push(GC gc, int i, TRCMethodInvocation inv, float x, float y, float w, float h) {
        JCanvas canvas = this.jcanvas();
        if (i >= 256 || canvas == null) {
            return;
        }
        if (this._drawArray[i] != null) {
            float yscale = canvas.yscale();
            float spaceforstring = (y - this._y[i]) * yscale;
            float spaceforinvoc = (y + h - this._y[i]) * yscale;
            if ((double)spaceforinvoc < 1.0) {
                return;
            }
            this.drawInvocation(gc, this._drawArray[i], this._x[i], this._y[i], this._w[i], this._h[i], (double)spaceforstring > 8.0);
        }
        this._drawArray[i] = inv;
        this._x[i] = x;
        this._y[i] = y;
        this._w[i] = w;
        this._h[i] = h;
    }

    public void redraw() {
        this.setDirty();
    }

    public void selected(float x, float y, boolean shiftdown, boolean controldown, boolean metadown) {
        if (this._viewroot == null) {
            return;
        }
        TRCFullMethodInvocation selinv = this.subtreeContains(this._viewroot, x - (float)this.cellWidth(), y + (float)((int)((float)TString.getTime((double)this._viewroot.getEntryTime()) * this.timescale)), 0);
        ITraceSelection _selectionmodel = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject());
        _selectionmodel.add((Object)selinv);
        ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
        event.setSource((Object)this._parent.getPage().getMOFObject());
        UIPlugin.getDefault().notifyViewSelectionChangedListener(event);
    }

    public void showCallee() {
        if (!this.hasCallee()) {
            return;
        }
        this._viewroot = (TRCFullMethodInvocation)this._calleeList.get(this._calleeList.size() - 1);
        this._calleeList.remove(this._viewroot);
        this._indexOfInvocation = 0;
        this.setTitle();
        this._parent.updateButtons();
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    public void showCaller() {
        if (!this.hasCaller()) {
            return;
        }
        this._calleeList.add(this._viewroot);
        this._viewroot = (TRCFullMethodInvocation)this._viewroot.getInvokedBy();
        this._indexOfInvocation = 0;
        this.setTitle();
        this._parent.updateButtons();
        this.jcanvas().zoomToFill(1.0f, 1000.0f);
        this.jcanvas().redraw();
    }

    public void shutdown() {
        this._viewroot = null;
        if (this._calleeList != null) {
            this._calleeList.clear();
        }
        this._drawArray = null;
        this._parent = null;
    }

    protected void status(String s) {
        this._parent.updateStatus(s);
    }

    protected TRCFullMethodInvocation subtreeContains(TRCFullMethodInvocation inv, float xs, float ys, int d) {
        if (inv == null) {
            return null;
        }
        int depth = (int)(xs / (float)this.cellWidth() / 4.0f);
        if (d == depth) {
            return inv;
        }
        if (d > depth) {
            return null;
        }
        double maxtime = inv.getOwningObject().getProcess().getLastEventTime();
        Object[] segments = inv.getInvokes().toArray();
        int i = 0;
        while (i < segments.length) {
            TRCFullMethodInvocation calleeinv = (TRCFullMethodInvocation)segments[i];
            double time = calleeinv.getExitTime();
            if (time == 0.0) {
                time = maxtime;
            }
            if (ys < (float)TString.getTime((double)calleeinv.getEntryTime()) * this.timescale + (float)this.titleMargin()) {
                return null;
            }
            if (time == 0.0 || (float)TString.getTime((double)time) * this.timescale + (float)this.titleMargin() >= ys) {
                return this.subtreeContains(calleeinv, xs, ys, d + 1);
            }
            ++i;
        }
        return null;
    }

    protected int titleMargin() {
        return 0;
    }

    protected int treeWidth() {
        return this.cellWidth() * 4 * (10 + this.maxDepth() / 10 * 10);
    }

    public float width() {
        return this.cellWidth() * 4 * (10 + this.maxDepth() / 10 * 10);
    }

    public void setDrawMode(int drawMode) {
        this._drawMode = drawMode;
    }

    protected void searchPattern() {
        this._calleeList.clear();
        Object obj = UIPlugin.getDefault().getSelectionModel(this._parent.getPage().getMOFObject()).getFirstElement();
        if (obj == null) {
            this._indexOfInvocation = 0;
            this._viewroot = null;
            return;
        }
        if (obj instanceof TRCMethodInvocation) {
            this._viewroot = (TRCFullMethodInvocation)obj;
            this._indexOfInvocation = 0;
        } else if (obj instanceof TRCMethod) {
            if (((TRCMethod)obj).getInvocations().size() == 0) {
                this._indexOfInvocation = 0;
                this._viewroot = null;
                return;
            }
            this._viewroot = (TRCFullMethodInvocation)((TRCMethod)obj).getInvocations().get(0);
            this._indexOfInvocation = 0;
        }
        this.setTitle();
        this._parent.updateButtons();
        this.resetArea();
    }
}

