/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.util.internal.IColorChangedListener;
import org.eclipse.hyades.trace.views.util.internal.IRefChangedListener;
import org.eclipse.hyades.trace.views.util.internal.ITimeChangedListener;
import org.eclipse.hyades.trace.views.util.internal.SpectrumColorMap;
import org.eclipse.hyades.trace.views.util.internal.UpdateModel;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class TraceUIPlugin
extends AbstractUIPlugin {
    private static TraceUIPlugin _plugin;
    public static final String PLUGIN_ID = "org.eclipse.hyades.trace.views";
    private ResourceBundle fResourceBundle;
    private ListenerList fColorChangedEventListeners = new ListenerList(20);
    private ListenerList fRefChangedEventListeners = new ListenerList(20);
    private ListenerList fTimeChangedEventListeners = new ListenerList(20);

    public TraceUIPlugin() {
        if (_plugin == null) {
            _plugin = this;
        }
    }

    public static TraceUIPlugin getDefault() {
        return _plugin;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return TracePluginImages.getImageDescriptor(name);
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        TracePluginImages.setImageDescriptors(action, type, relPath);
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public ResourceBundle getResourceBundle() {
        block2: {
            if (this.fResourceBundle != null) break block2;
            try {
                this.fResourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
                this.fResourceBundle = null;
            }
        }
        return this.fResourceBundle;
    }

    public static String getString(String key) {
        ResourceBundle bundle = TraceUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"background_rgb", (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"selection_rgb", (RGB)new RGB(255, 255, 149));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"unknown_rgb", (RGB)new RGB(128, 128, 128));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"classes_rgb", (RGB)new RGB(71, 141, 141));
        store.setDefault("bg_option", "system_default");
        store.setDefault("class_option", "class_default_color");
        store.setDefault("obj_ref_display", 0);
        store.setDefault("time_display", 0);
        store.setDefault("percent", 0);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.savePluginPreferences();
        SpectrumColorMap.shutdown();
        TracePluginImages.shutdown();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)new UpdateModel());
        SpectrumColorMap.startup();
    }

    public void addColorChangedEventListener(IColorChangedListener listener) {
        this.fColorChangedEventListeners.add((Object)listener);
    }

    public void addRefChangedEventListener(IRefChangedListener listener) {
        this.fRefChangedEventListeners.add((Object)listener);
    }

    public void addTimeChangedEventListener(ITimeChangedListener listener) {
        this.fTimeChangedEventListeners.add((Object)listener);
    }

    public void removeColorChangedEventListener(IColorChangedListener listener) {
        this.fColorChangedEventListeners.remove((Object)listener);
    }

    public void removeRefChangedEventListener(IRefChangedListener listener) {
        this.fRefChangedEventListeners.remove((Object)listener);
    }

    public void removeTimeChangedEventListener(ITimeChangedListener listener) {
        this.fTimeChangedEventListeners.remove((Object)listener);
    }

    public void notifyColorChangedEventListener() {
        Object[] listeners = this.fColorChangedEventListeners.getListeners();
        int idx = 0;
        while (idx < listeners.length) {
            ((IColorChangedListener)listeners[idx]).handleColorChangedEvent();
            ++idx;
        }
    }

    public void notifyRefChangedEventListener() {
        Object[] listeners = this.fRefChangedEventListeners.getListeners();
        int idx = 0;
        while (idx < listeners.length) {
            ((IRefChangedListener)listeners[idx]).handleRefChangedEvent();
            ++idx;
        }
    }

    public void notifyTimeChangedEventListener() {
        Object[] listeners = this.fTimeChangedEventListeners.getListeners();
        int idx = 0;
        while (idx < listeners.length) {
            ((ITimeChangedListener)listeners[idx]).handleTimeChangedEvent();
            ++idx;
        }
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }
}

