/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCSourceInfo;

public class CoverageUtil {
    private static final int Path_Separator = 46;

    private static String getSourceSig(TRCSourceInfo e) {
        return e != null ? e.getLocation() + ":" : "";
    }

    public static String getFullSig(TRCMethod e) {
        return CoverageUtil.getSourceSig(e.getSourceInfo()) + e.getLineNo() + ":" + CoverageUtil.getSig(e.getDefiningClass()) + "." + e.getName() + e.getSignature();
    }

    public static String getFullSig(TRCClass e) {
        return CoverageUtil.getSourceSig(e.getSourceInfo()) + e.getLineNo() + ":" + CoverageUtil.getSig(e);
    }

    public static String getFullSig(TRCPackage e) {
        return e.getName();
    }

    private static String getSig(TRCClass e) {
        return (e.getPackage().getName() == null ? "" : e.getPackage().getName() + ".") + e.getName();
    }

    public static boolean isFiltered(TRCPackage pac) {
        if (pac.getClasses() == null || pac.getClasses().size() == 0) {
            return true;
        }
        Object[] conflist = pac.getProcess().getAgent().getAgentProxy().getConfigurations().toArray();
        int idxmax = conflist.length;
        int idx = 0;
        while (idx < idxmax) {
            TRCConfiguration c = (TRCConfiguration)conflist[idx];
            if (c.isActive()) {
                Object[] filtlist = c.getFilters().toArray();
                int k = 0;
                while (k < filtlist.length) {
                    TRCFilter f = (TRCFilter)filtlist[k];
                    if (f.getActive().booleanValue() && CoverageUtil.isFilteredPackage(f, pac)) {
                        return true;
                    }
                    ++k;
                }
            }
            ++idx;
        }
        return false;
    }

    public static boolean isFiltered(TRCClass cl) {
        if (cl.getMethods() == null || cl.getMethods().size() == 0) {
            return true;
        }
        Object[] conflist = cl.getPackage().getProcess().getAgent().getAgentProxy().getConfigurations().toArray();
        int idxmax = conflist.length;
        int idx = 0;
        while (idx < idxmax) {
            TRCConfiguration c = (TRCConfiguration)conflist[idx];
            if (c.isActive()) {
                Object[] filtlist = c.getFilters().toArray();
                int k = 0;
                while (k < filtlist.length) {
                    TRCFilter f = (TRCFilter)filtlist[k];
                    if (f.getActive().booleanValue() && CoverageUtil.isFilteredClass(f, cl)) {
                        return true;
                    }
                    ++k;
                }
            }
            ++idx;
        }
        return false;
    }

    private static boolean isFilteredPackage(TRCFilter filter, TRCPackage pack) {
        String methodPattern;
        String pattern = filter.getPattern();
        String mode = filter.getMode();
        String type = filter.getType();
        if (type.equals(mode)) {
            type = CoverageUtil.parseFilterPattern(pattern);
        }
        if ((methodPattern = filter.getOperation()) != null && methodPattern.length() > 0 && !methodPattern.equals("*")) {
            return false;
        }
        String name = pack.getName();
        boolean exclude = true;
        if (mode.equals("INCLUDE")) {
            exclude = false;
        }
        if (type.equals("NONE") ? name.equals(pattern) : (type.equals("PREFIX") ? name.endsWith(pattern) : type.equals("SUFFIX") && name.startsWith(pattern))) {
            return exclude;
        }
        return false;
    }

    private static boolean isFilteredClass(TRCFilter filter, TRCClass cl) {
        String methodPattern;
        String pattern = filter.getPattern();
        String mode = filter.getMode();
        String type = filter.getType();
        if (type.equals(mode)) {
            type = CoverageUtil.parseFilterPattern(pattern);
        }
        if ((methodPattern = filter.getOperation()) != null && methodPattern.length() > 0 && !methodPattern.equals("*")) {
            return false;
        }
        String name = cl.getName();
        if (pattern.indexOf(46) != -1) {
            name = cl.getPackage().getName() + 46 + name;
        }
        boolean exclude = true;
        if (mode.equals("INCLUDE")) {
            exclude = false;
        }
        if (type.equals("NONE") ? name.equals(pattern) : (type.equals("PREFIX") ? name.endsWith(pattern) : type.equals("SUFFIX") && name.startsWith(pattern))) {
            return exclude;
        }
        return false;
    }

    private static String parseFilterPattern(String filterPattern) {
        String genericPattern = "NONE";
        if (filterPattern.length() == 0) {
            return genericPattern;
        }
        int p = filterPattern.indexOf(42);
        if (p == 0) {
            genericPattern = "PREFIX";
            filterPattern = filterPattern.substring(1);
        } else if (p == filterPattern.length() - 1) {
            genericPattern = "SUFFIX";
            filterPattern = filterPattern.substring(0, filterPattern.length() - 2);
        }
        return genericPattern;
    }
}

