/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PrintColumnsDialog
extends Dialog
implements SelectionListener,
Listener,
ModifyListener {
    private Text _txtTargetFileName;
    private Button _btnTargetBrowse;
    private String _fileName = "";
    private String _title;
    private Shell _shell;

    public PrintColumnsDialog(Shell shell, String windowTitle, Image windowImage) {
        super(shell);
        this._shell = shell;
        this._title = windowTitle;
        Window.setDefaultImage((Image)windowImage);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this._title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite targetGrp = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 4;
        GridData data = GridUtil.createHorizontalFill();
        data.widthHint = 300;
        targetGrp.setLayout((Layout)layout);
        targetGrp.setLayoutData((Object)data);
        Label locationLabel = new Label(targetGrp, 0);
        data = new GridData();
        data.horizontalSpan = 3;
        locationLabel.setLayoutData((Object)data);
        locationLabel.setText(TraceUIPlugin.getString("STR_PRINT_DLG_TEXT"));
        Label targetLabel = new Label(targetGrp, 0);
        data = new GridData();
        targetLabel.setLayoutData((Object)data);
        targetLabel.setText(TraceUIPlugin.getString("STR_PRINT_DLG_FILE"));
        this._txtTargetFileName = new Text(targetGrp, 2048);
        this._txtTargetFileName.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._btnTargetBrowse = new Button(targetGrp, 8);
        this._btnTargetBrowse.setText(TraceUIPlugin.getString("STR_PRINT_DLG_BROWSE"));
        this._btnTargetBrowse.addListener(13, (Listener)this);
        this._txtTargetFileName.addModifyListener((ModifyListener)this);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this._fileName = this._txtTargetFileName.getText().trim();
        if (this._fileName == null || this._fileName.equals("")) {
            MessageDialog.openError((Shell)this._shell, (String)TraceUIPlugin.getString("STR_TRACE_MSG"), (String)TraceUIPlugin.getString("STR_PRINT_DLG_ERROR"));
            return;
        }
        super.okPressed();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void handleEvent(Event event) {
        if (event.widget == this._btnTargetBrowse) {
            this.showTargetDialog();
        }
    }

    private void showTargetDialog() {
        String currentSource = this._txtTargetFileName.getText();
        FileDialog dlg = new FileDialog(this.getShell(), 8192);
        dlg.setFileName(currentSource);
        dlg.setFilterExtensions(new String[]{"*.htm", "*.*"});
        String target = dlg.open();
        if (target != null) {
            this._txtTargetFileName.setText(target);
        }
        this._fileName = target;
    }

    public void modifyText(ModifyEvent e) {
    }

    public String getFileName() {
        return this._fileName;
    }
}

