/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.trace.util;

import org.eclipse.hyades.execution.trace.util.RecordAgentCreate;
import org.eclipse.hyades.execution.trace.util.RecordTraceStart;
import org.eclipse.hyades.execution.trace.util.Utilities;
import org.eclipse.hyades.internal.execution.remote.AgentControllerListener;
import org.eclipse.hyades.internal.execution.remote.MonitorListener;
import org.eclipse.hyades.internal.execution.remote.QueueManager;
import org.eclipse.hyades.internal.execution.remote.RemoteComponentSkeleton;

public abstract class ProfilerImpl
implements MonitorListener,
AgentControllerListener {
    private RemoteComponentSkeleton _agent = null;
    private boolean _isMonitored = false;
    private boolean _isAgentControllerAvailable = false;
    private RecordAgentCreate _agentRecord = null;
    private QueueManager _messageQueue = new QueueManager();
    private String _agentId = null;
    private String _processId = null;
    private String _nodeId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProfilerImpl(String name, String type) {
        ProfilerImpl profilerImpl = this;
        synchronized (profilerImpl) {
            try {
                this._agent = new RemoteComponentSkeleton(name, type);
                this._agent.addMonitorListener((MonitorListener)this);
                this._agent.addAgentControllerListener((AgentControllerListener)this);
                this._agent.initializeFast();
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void agentControllerActive() {
        try {
            ProfilerImpl profilerImpl = this;
            synchronized (profilerImpl) {
                this._agentId = this._agent.getAgentUUID();
                this._processId = this._agent.getJVMUUID();
                this._nodeId = this._agent.getNodeUUID();
                this._agentRecord = new RecordAgentCreate(this._agentId, this._processId, this._nodeId, this._agent.getName(), Utilities.getCurrentTimeStamp());
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        this._isAgentControllerAvailable = true;
    }

    public void agentControllerInactive() {
        this._isAgentControllerAvailable = false;
        this._isMonitored = false;
    }

    public void monitorActive() {
        this._isMonitored = true;
        this.write(this._agentRecord.toString());
        this.write(new RecordTraceStart(this._agent.getAgentUUID()).toString());
        this.flushMessageQueue();
    }

    public void monitorInactive() {
        this._isMonitored = false;
    }

    public void write(String message) {
        if (this._isAgentControllerAvailable && this._isMonitored) {
            this._agent.logMessageUTF8(message);
        } else {
            this._messageQueue.insertInQueue(message);
        }
    }

    public void flushMessageQueue() {
        if (this._messageQueue.isFlushNeeded() && this._isAgentControllerAvailable && this._isMonitored) {
            this._messageQueue.flushCurrentQueue(this._agent);
        }
    }

    public void finalize() {
        this._agent.deregister();
    }

    public String getAgentId() {
        return this._agentId;
    }

    public String getProcessId() {
        return this._processId;
    }

    public String getNodeId() {
        return this._nodeId;
    }
}

