/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import org.eclipse.hyades.logging.adapter.IStatus;

public class Status
implements IStatus {
    private String name = null;
    private boolean active = false;
    private int itemsProcessedCount = 0;
    private IStatus[] children = null;
    private long startTime = 0L;
    private long endTime = 0L;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active && this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        } else if (!active && this.startTime != 0L && this.endTime == 0L) {
            this.endTime = System.currentTimeMillis();
        }
    }

    public boolean isActive() {
        if (this.hasChildren()) {
            this.active = false;
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null && this.children[i].isActive()) {
                    this.active = true;
                    break;
                }
                ++i;
            }
        }
        return this.active;
    }

    public void setItemsProcessedCount(int itemsProcessedCount) {
        this.itemsProcessedCount = itemsProcessedCount;
    }

    public int getItemsProcessedCount() {
        if (this.hasChildren()) {
            int count = 0;
            int i = 0;
            while (i < this.children.length) {
                if (this.children[i] != null) {
                    if (((Status)this.children[i]).hasChildren()) {
                        count += this.children[i].getItemsProcessedCount();
                    } else if (i == this.children.length - 1) {
                        count += this.children[i].getItemsProcessedCount();
                    }
                }
                ++i;
            }
            this.itemsProcessedCount = count;
        }
        return this.itemsProcessedCount;
    }

    public void setChildrenStatus(IStatus[] children) {
        this.children = children;
    }

    public IStatus[] getChildrenStatus() {
        return this.children;
    }

    public IStatus getChildStatus(String name) {
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] != null && this.children[i].getName().equals(name)) {
                return this.children[i];
            }
            ++i;
        }
        return null;
    }

    private boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    public long getElapsedTimeInMilliseconds() {
        if (this.startTime != 0L && this.endTime != 0L) {
            return this.endTime - this.startTime;
        }
        if (this.startTime != 0L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return -1L;
    }

    public float getElpasedTimeInSeconds() {
        long eTime = this.getElapsedTimeInMilliseconds();
        if (eTime != -1L) {
            return (float)eTime / 1000.0f;
        }
        return -1.0f;
    }
}

