/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenJavaSource {
    private static final String JAVA_PERSPECTIVE_ID = "org.eclipse.jdt.ui.JavaPerspective";

    public static boolean openSource(String pattern, int javaType, IJavaSearchScope searchScope, boolean switchToJavaPerspective) {
        OpenSourceJavaSearchResultRequestor requestor = OpenJavaSource.getSearchResults(pattern, javaType, searchScope);
        if (requestor != null && requestor.getNumberOfMatches() > 0) {
            return OpenJavaSource.openWbSource(requestor.getMatchForPattern(pattern), switchToJavaPerspective);
        }
        return false;
    }

    public static IFile getSourceFile(String pattern, int javaType, IJavaSearchScope searchScope) {
        OpenSourceJavaSearchResultRequestor requestor = OpenJavaSource.getSearchResults(pattern, javaType, searchScope);
        if (requestor != null) {
            return OpenSourceJavaSearchResultRequestor.getFile(requestor.getMatchForPattern(pattern));
        }
        return null;
    }

    private static String fixPatternForInnerClasses(String pattern, int javaType) {
        int bIdx = pattern.indexOf("(");
        int idx = bIdx >= 0 ? pattern.substring(0, bIdx).lastIndexOf("$") : pattern.lastIndexOf("$");
        if (idx >= 0) {
            pattern = pattern.replace('$', '.');
            if (bIdx >= 0 && javaType == 3) {
                String outerClass = pattern.substring(0, idx);
                String outerClassParamater = outerClass + ",";
                pattern = pattern.indexOf(outerClassParamater) >= 0 ? pattern.replaceAll(outerClassParamater, "") : outerClass + pattern.replaceAll(outerClass, "");
            }
        }
        return pattern;
    }

    private static SearchPattern getSearchPattern(String pattern, int javaType) {
        if (pattern != null && !"".equals(pattern)) {
            pattern = OpenJavaSource.fixPatternForInnerClasses(pattern, javaType);
            return SearchPattern.createPattern((String)pattern, (int)javaType, (int)0, (int)8);
        }
        return null;
    }

    private static IJavaSearchScope getJavaSearchScope(IJavaSearchScope searchScope) {
        if (searchScope == null) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            IJavaElement[] javaElements = new IJavaElement[projects.length];
            int i = 0;
            while (i < projects.length) {
                javaElements[i] = JavaCore.create((IProject)projects[i]);
                ++i;
            }
            searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (boolean)false);
        }
        return searchScope;
    }

    private static OpenSourceJavaSearchResultRequestor getSearchResults(String pattern, int javaType, IJavaSearchScope searchScope) {
        SearchPattern searchPattern = OpenJavaSource.getSearchPattern(pattern, javaType);
        if (searchPattern != null) {
            OpenSourceJavaSearchResultRequestor requestor = new OpenSourceJavaSearchResultRequestor();
            SearchEngine searchEngine = new SearchEngine();
            try {
                searchEngine.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, OpenJavaSource.getJavaSearchScope(searchScope), (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                // empty catch block
            }
            return requestor;
        }
        return null;
    }

    private static boolean openWbSource(SearchMatch match, boolean switchToJavaPerspective) {
        IWorkbenchPage page = null;
        page = switchToJavaPerspective ? OpenJavaSource.getJavaActivePage() : UIUtil.getActiveWorkbenchPage();
        if (page == null) {
            return false;
        }
        IJavaElement je = (IJavaElement)match.getElement();
        StructuredSelection ss = new StructuredSelection((Object)je);
        try {
            OpenAction openAction = new OpenAction((IWorkbenchSite)page.getActivePart().getSite());
            openAction.run((IStructuredSelection)ss);
            return true;
        }
        catch (Exception e) {
            HyadesUIPlugin.logError(e);
            return false;
        }
    }

    private static IWorkbenchPage getJavaActivePage() {
        IWorkbenchPage page;
        block5: {
            page = UIUtil.getActiveWorkbenchPage();
            if (page != null && page.getPerspective().getId().equals(JAVA_PERSPECTIVE_ID)) break block5;
            IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            page = null;
            try {
                IWorkbenchPage[] persps = dwindow.getPages();
                int idx = 0;
                while (idx < persps.length) {
                    if (persps[idx].getPerspective().getId().equals(JAVA_PERSPECTIVE_ID)) {
                        page = persps[idx];
                        dwindow.setActivePage(page);
                        break;
                    }
                    ++idx;
                }
                if (page != null) break block5;
                IWorkspaceRoot element = ResourcesPlugin.getWorkspace().getRoot();
                IWorkbench workBench = dwindow.getWorkbench();
                if (workBench != null && element != null) {
                    page = workBench.showPerspective(JAVA_PERSPECTIVE_ID, dwindow, (IAdaptable)element);
                }
            }
            catch (Exception exc) {
                HyadesUIPlugin.logError(exc);
            }
        }
        return page;
    }

    private static class OpenSourceJavaSearchResultRequestor
    extends SearchRequestor {
        private Vector _matches = new Vector();

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this._matches.addElement(match);
        }

        public int getNumberOfMatches() {
            return this._matches.size();
        }

        public SearchMatch getMatch(int i) {
            return (SearchMatch)this._matches.elementAt(i);
        }

        public SearchMatch getFirstMatch() {
            if (this.getNumberOfMatches() > 0) {
                return this.getMatch(0);
            }
            return null;
        }

        public SearchMatch getMatchForPattern(String pattern) {
            block4: {
                if (this.getNumberOfMatches() <= 1) break block4;
                try {
                    IJavaElement je = null;
                    IMethod me = null;
                    int i = 0;
                    while (i < this.getNumberOfMatches()) {
                        je = (IJavaElement)this.getMatch(i).getElement();
                        if (je instanceof IMethod && !(me = (IMethod)je).isConstructor() && pattern.indexOf(me.getDeclaringType().getFullyQualifiedName()) >= 0) {
                            return this.getMatch(i);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    HyadesUIPlugin.logError(e);
                }
            }
            return this.getFirstMatch();
        }

        public static IFile getFile(SearchMatch match) {
            if (match != null && match.getResource() instanceof IFile) {
                return (IFile)match.getResource();
            }
            return null;
        }
    }
}

