/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.LogUIPluginImages;
import org.eclipse.hyades.log.ui.internal.util.IRecordPaneViewerListener;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.LogUtil;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBPackageImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class LogUIPlugin
extends AbstractUIPlugin {
    private static LogUIPlugin inst;
    private static ResourceBundle fResourceBundle;
    private SDBFactoryImpl factory;
    private ResourceSet resourceSet;
    private ArrayList recordChangeListeners = null;
    private IConfigurationElement newSymptomWizardElement = null;
    private boolean newSymptomWizardElementInit;
    public static final String PLUGIN_ID = "org.eclipse.hyades.log.ui";

    public LogUIPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public static LogUIPlugin getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return LogUIPluginImages.getImageDescriptor(name);
    }

    public static ResourceBundle getResourceBundle() {
        block2: {
            if (fResourceBundle != null) break block2;
            try {
                fResourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (Exception e) {
                fResourceBundle = null;
            }
        }
        return fResourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = LogUIPlugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getResourceString(String key, String[] variables) {
        String value = LogUIPlugin.getResourceString(key);
        int i = variables.length;
        while (i > 0) {
            value = StringUtil.replace((String)value, (String)("%" + i), (String)variables[i - 1]);
            --i;
        }
        return value;
    }

    public static Shell getActiveWorkbenchShell() {
        return LogUIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return LogUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static void log(Throwable e) {
        String msg = e.getMessage();
        LogUIPlugin.getDefault().getLog().log((IStatus)new Status(4, LogUIPlugin.getPluginId(), 4, msg == null ? "" : msg, e));
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        LogUIPluginImages.shutdown();
        this.savePluginPreferences();
        fResourceBundle = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        SDBPackageImpl.init();
        this.factory = new SDBFactoryImpl();
        this.resourceSet = SDBResourceSetImpl.getInstance();
    }

    public SDBFactoryImpl getSymptomDBFactory() {
        if (this.factory == null) {
            this.factory = new SDBFactoryImpl();
        }
        return this.factory;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public static DateFormat getDateTimeFormat() {
        return DateFormat.getDateTimeInstance(LogUIPlugin.getDateStyle(), LogUIPlugin.getTimeStyle(), Locale.getDefault());
    }

    public static int getDateStyle() {
        IPreferenceStore store = inst.getPreferenceStore();
        String dateFormat = store.getString("LogAnalyzer.DateFormat");
        boolean valid = false;
        int i = 0;
        while (i < LogUIConstants.DATE_FORMAT_LIST.length) {
            if (dateFormat.equals(LogUIConstants.DATE_FORMAT_LIST[i])) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            dateFormat = LogUIConstants.LOG_ANALYZER_FORMAT_DATE_DEFAULT;
        }
        if (dateFormat.equals(LogUIConstants.DATE_FORMAT_FULL)) {
            return 0;
        }
        if (dateFormat.equals(LogUIConstants.DATE_FORMAT_LONG)) {
            return 1;
        }
        if (dateFormat.equals(LogUIConstants.DATE_FORMAT_MEDIUM)) {
            return 2;
        }
        if (dateFormat.equals(LogUIConstants.DATE_FORMAT_SHORT)) {
            return 3;
        }
        return 2;
    }

    public static int getTimeStyle() {
        IPreferenceStore store = inst.getPreferenceStore();
        String timeFormat = store.getString("LogAnalyzer.TimeFormat");
        boolean valid = false;
        int i = 0;
        while (i < LogUIConstants.TIME_FORMAT_LIST.length) {
            if (timeFormat.equals(LogUIConstants.TIME_FORMAT_LIST[i])) {
                valid = true;
                break;
            }
            ++i;
        }
        if (!valid) {
            timeFormat = LogUIConstants.LOG_ANALYZER_FORMAT_TIME_DEFAULT;
        }
        if (timeFormat.equals(LogUIConstants.TIME_FORMAT_FULL)) {
            return 0;
        }
        if (timeFormat.equals(LogUIConstants.TIME_FORMAT_LONG)) {
            return 1;
        }
        if (timeFormat.equals(LogUIConstants.TIME_FORMAT_MEDIUM)) {
            return 2;
        }
        if (timeFormat.equals(LogUIConstants.TIME_FORMAT_SHORT)) {
            return 3;
        }
        return 2;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        LogUtil.initializePreferenceStore(store);
    }

    public void addRecordPaneViewerListener(IRecordPaneViewerListener listener) {
        if (this.recordChangeListeners == null) {
            this.recordChangeListeners = new ArrayList();
        }
        if (!this.recordChangeListeners.contains(listener)) {
            this.recordChangeListeners.add(listener);
        }
    }

    public void removeRecordPaneViewerListener(IRecordPaneViewerListener listener) {
        if (this.recordChangeListeners != null) {
            this.recordChangeListeners.remove(listener);
        }
    }

    public void fireRecordChangeNotification(RecordChangeEvent e) {
        if (this.recordChangeListeners != null) {
            int i = 0;
            while (i < this.recordChangeListeners.size()) {
                ((IRecordPaneViewerListener)this.recordChangeListeners.get(i)).handleRecordChangeEvent(e);
                ++i;
            }
        }
    }

    public INewWizard getNewSymDBWizard() {
        try {
            if (!this.newSymptomWizardElementInit) {
                this.newSymptomWizardElementInit = true;
                this.loadWizardExtention();
            }
            if (this.newSymptomWizardElement != null) {
                return (INewWizard)this.newSymptomWizardElement.createExecutableExtension("class");
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void loadWizardExtention() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configurationElements = registry.getConfigurationElementsFor("org.eclipse.ui.newWizards");
        if (configurationElements != null) {
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configurationElement = configurationElements[i];
                if (configurationElement.getName().equals("wizard") && configurationElement.getAttribute("id").endsWith("wizard.new.symptomdb")) {
                    this.newSymptomWizardElement = configurationElement;
                }
                ++i;
            }
        }
    }

    static {
        fResourceBundle = null;
    }
}

