/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder;
import org.eclipse.hyades.ui.internal.provider.IResourceChangeUpdater;
import org.eclipse.hyades.ui.internal.provider.ResourceChangeUpdaterProvider;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.swt.widgets.Display;

public class LogNavigatorSynchronizer
extends AdapterImpl
implements IDisposable,
IResourceChangeUpdater {
    private LogNavigator navigator;
    private boolean active;
    private Collection addedResources;
    private Collection removedResources;
    private Collection changedResources;
    private Collection adaptedObjects = new ArrayList();

    public LogNavigatorSynchronizer(LogNavigator navigator) {
        this.navigator = navigator;
        this.active = true;
    }

    public void dispose() {
        Iterator iter = this.adaptedObjects.iterator();
        while (iter.hasNext()) {
            Notifier element = (Notifier)iter.next();
            element.eAdapters().remove((Object)this);
        }
        this.adaptedObjects.clear();
        this.navigator = null;
    }

    public void register(ResourceChangeUpdaterProvider updaterProvider, ResourceSet resourceSet) {
        if (updaterProvider != null) {
            updaterProvider.setResourceChangeUpdater((IResourceChangeUpdater)this);
        }
        if (resourceSet != null && resourceSet.eAdapters().add((Object)this)) {
            Iterator i = resourceSet.getResources().iterator();
            while (i.hasNext()) {
                this.handleAdd((Resource)i.next());
            }
        }
    }

    public void notifyChanged(Notification msg) {
        if (!this.isActive()) {
            return;
        }
        switch (msg.getEventType()) {
            case 3: {
                Object newValue = msg.getNewValue();
                if (newValue instanceof Resource) {
                    this.handleAdd((Resource)newValue);
                    break;
                }
                if (newValue instanceof TRCProcessProxy) {
                    this.handleAdd((TRCProcessProxy)newValue);
                    break;
                }
                if (newValue instanceof TRCAgentProxy) {
                    this.handleAdd((TRCAgentProxy)newValue);
                    break;
                }
                if (newValue instanceof TRCMonitor) {
                    this.handleAdd((TRCMonitor)newValue);
                    break;
                }
                if (!(newValue instanceof CorrelationContainerProxy)) break;
                this.handleAdd((CorrelationContainerProxy)newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)msg.getNewValue();
                Iterator i = newValues.iterator();
                while (i.hasNext()) {
                    Object newValue = i.next();
                    if (newValue instanceof Resource) {
                        this.handleAdd((Resource)newValue);
                        continue;
                    }
                    if (newValue instanceof TRCProcessProxy) {
                        this.handleAdd((TRCProcessProxy)newValue);
                        continue;
                    }
                    if (newValue instanceof TRCAgentProxy) {
                        this.handleAdd((TRCAgentProxy)newValue);
                        continue;
                    }
                    if (newValue instanceof TRCMonitor) {
                        this.handleAdd((TRCMonitor)newValue);
                        continue;
                    }
                    if (!(newValue instanceof CorrelationContainerProxy)) continue;
                    this.handleAdd((CorrelationContainerProxy)newValue);
                }
                break;
            }
            case 4: {
                Object oldValue = msg.getOldValue();
                if (oldValue instanceof Resource) {
                    this.handleRemove((Resource)oldValue);
                } else if (oldValue instanceof TRCProcessProxy) {
                    this.handleRemove((TRCProcessProxy)oldValue);
                } else if (oldValue instanceof TRCAgentProxy) {
                    this.handleRemove((TRCAgentProxy)oldValue);
                } else if (oldValue instanceof TRCMonitor) {
                    this.handleRemove((TRCMonitor)oldValue);
                } else if (oldValue instanceof CorrelationContainerProxy) {
                    this.handleRemove((CorrelationContainerProxy)oldValue);
                }
                if (!(msg.getNotifier() instanceof CorrelationContainerProxy) || msg.getFeature() != HierarchyPackage.eINSTANCE.getCorrelationContainerProxy_CorrelatedAgents()) break;
                CorrelationContainerProxy correlationContainerProxy = (CorrelationContainerProxy)msg.getNotifier();
                if (correlationContainerProxy.getCorrelatedAgents().size() == 0) {
                    correlationContainerProxy.setMonitor(null);
                }
                this.getNavigator().getViewer().refresh(msg.getNotifier());
                break;
            }
            case 6: {
                Collection oldValues = (Collection)msg.getOldValue();
                Iterator i = oldValues.iterator();
                while (i.hasNext()) {
                    Object oldValue = i.next();
                    if (oldValue instanceof Resource) {
                        this.handleRemove((Resource)oldValue);
                        continue;
                    }
                    if (oldValue instanceof TRCProcessProxy) {
                        this.handleRemove((TRCProcessProxy)oldValue);
                        continue;
                    }
                    if (oldValue instanceof TRCAgentProxy) {
                        this.handleRemove((TRCAgentProxy)oldValue);
                        continue;
                    }
                    if (oldValue instanceof TRCMonitor) {
                        this.handleRemove((TRCMonitor)oldValue);
                        continue;
                    }
                    if (!(oldValue instanceof CorrelationContainerProxy)) continue;
                    this.handleRemove((CorrelationContainerProxy)oldValue);
                }
                break;
            }
            case 1: {
                if (msg.getNotifier() instanceof TRCAgentProxy) {
                    this.handleSet((TRCAgentProxy)msg.getNotifier());
                    break;
                }
                if (!(msg.getNotifier() instanceof CorrelationContainerProxy)) break;
                this.refreshTree(msg.getNotifier());
            }
        }
    }

    protected void handleRemove(TRCMonitor proxy) {
        proxy.eAdapters().remove((Object)this);
        this.adaptedObjects.remove(proxy);
        Iterator i = proxy.getCorrelationContainerProxies().iterator();
        while (i.hasNext()) {
            this.handleRemove((CorrelationContainerProxy)i.next());
        }
    }

    protected void handleRemove(CorrelationContainerProxy proxy) {
        LogicalFolder corrLogicalFolder = this.navigator.getContentProvider().getCorrelationFolder();
        proxy.eAdapters().remove((Object)this);
        this.adaptedObjects.remove(proxy);
        if (corrLogicalFolder.getChildren().remove(proxy)) {
            this.removeFromTree(proxy);
        }
    }

    protected void handleAdd(Resource resource) {
        block4: {
            block3: {
                if (!"trcpxmi".equals(resource.getURI().fileExtension())) break block3;
                if (!resource.eAdapters().add((Object)this)) break block4;
                this.adaptedObjects.add(resource);
                Iterator i = resource.getContents().iterator();
                while (i.hasNext()) {
                    EObject eObject = (EObject)i.next();
                    if (!(eObject instanceof TRCProcessProxy)) continue;
                    this.handleAdd((TRCProcessProxy)eObject);
                }
                break block4;
            }
            if ("trcmxmi".equals(resource.getURI().fileExtension()) && resource.eAdapters().add((Object)this)) {
                this.adaptedObjects.add(resource);
                Iterator i = resource.getContents().iterator();
                while (i.hasNext()) {
                    EObject eObject = (EObject)i.next();
                    if (!(eObject instanceof TRCMonitor)) continue;
                    this.handleAdd((TRCMonitor)eObject);
                }
            }
        }
    }

    private void handleAdd(TRCMonitor monitor) {
        if (monitor.eAdapters().add((Object)this)) {
            this.adaptedObjects.add(monitor);
            Iterator i = monitor.getCorrelationContainerProxies().iterator();
            while (i.hasNext()) {
                this.handleAdd((CorrelationContainerProxy)i.next());
            }
        }
    }

    private void handleAdd(CorrelationContainerProxy proxy) {
        LogicalFolder corrLogicalFolder = this.navigator.getContentProvider().getCorrelationFolder();
        if (proxy.eAdapters().add((Object)this)) {
            this.adaptedObjects.add(proxy);
            if (!corrLogicalFolder.getChildren().contains(proxy)) {
                corrLogicalFolder.getChildren().add(proxy);
                this.addToTree((Object)this.navigator.getContentProvider().getCorrelationFolder(), proxy);
            }
        }
    }

    protected void handleAdd(TRCProcessProxy processProxy) {
        if (processProxy.eAdapters().add((Object)this)) {
            this.adaptedObjects.add(processProxy);
            Iterator i = processProxy.getAgentProxies().iterator();
            while (i.hasNext()) {
                this.handleAdd((TRCAgentProxy)i.next());
            }
        }
    }

    protected void handleAdd(TRCAgentProxy agentProxy) {
        if ("Logging".equals(agentProxy.getType())) {
            LogicalFolder logLogicalFolder = this.navigator.getContentProvider().getLogFolder();
            this.refreshTree(logLogicalFolder);
        }
    }

    protected void handleRemove(Resource resource) {
        block4: {
            block5: {
                block3: {
                    if (!"trcpxmi".equals(resource.getURI().fileExtension())) break block3;
                    resource.eAdapters().remove((Object)this);
                    this.adaptedObjects.remove(resource);
                    Iterator i = resource.getContents().iterator();
                    while (i.hasNext()) {
                        EObject eObject = (EObject)i.next();
                        if (!(eObject instanceof TRCProcessProxy)) continue;
                        this.handleRemove((TRCProcessProxy)eObject);
                    }
                    break block4;
                }
                if (!"trcmxmi".equals(resource.getURI().fileExtension())) break block5;
                this.adaptedObjects.remove(resource);
                Iterator i = resource.getContents().iterator();
                while (i.hasNext()) {
                    EObject eObject = (EObject)i.next();
                    if (!(eObject instanceof TRCMonitor)) continue;
                    this.handleRemove((TRCMonitor)eObject);
                }
                break block4;
            }
            if (!"trcaxmi".equals(resource.getURI().fileExtension())) break block4;
            resource.eAdapters().remove((Object)this);
            this.adaptedObjects.remove(resource);
            Iterator i = resource.getContents().iterator();
            while (i.hasNext()) {
                EObject eObject = (EObject)i.next();
                if (!(eObject instanceof TRCAgentProxy)) continue;
                this.handleRemove((TRCAgentProxy)eObject);
            }
        }
    }

    protected void handleRemove(TRCProcessProxy processProxy) {
        processProxy.eAdapters().remove((Object)this);
        this.adaptedObjects.remove(processProxy);
        Iterator i = processProxy.getAgentProxies().iterator();
        while (i.hasNext()) {
            this.handleRemove((TRCAgentProxy)i.next());
        }
    }

    protected void handleRemove(TRCAgentProxy agentProxy) {
        if ("Logging".equals(agentProxy.getType())) {
            LogicalFolder logLogicalFolder = this.navigator.getContentProvider().getLogFolder();
            this.refreshTree(logLogicalFolder);
        }
    }

    protected void handleSet(TRCAgentProxy agentProxy) {
        if ("Logging".equals(agentProxy.getType())) {
            this.refreshTree(agentProxy);
        }
    }

    public void setActive(boolean enable) {
        this.active = enable;
    }

    public boolean isActive() {
        return this.active;
    }

    public void started() {
        this.addedResources = new ArrayList();
        this.removedResources = new ArrayList();
        this.changedResources = new ArrayList();
    }

    public void ended() {
        LogicalFolder sdFolder = this.navigator.getContentProvider().getSDFolder();
        boolean doRefresh = false;
        if (!this.removedResources.isEmpty()) {
            int initialSize = sdFolder.getChildren().size();
            Iterator i = this.removedResources.iterator();
            while (i.hasNext()) {
                IResource resource = (IResource)i.next();
                if (resource.getType() == 1) continue;
                IPath fullPath = resource.getFullPath();
                IResource[] resources = sdFolder.getChildren().toArray(new IResource[sdFolder.getChildren().size()]);
                int j = 0;
                int maxj = resources.length;
                while (j < maxj) {
                    if (fullPath.isPrefixOf(resources[j].getFullPath())) {
                        sdFolder.getChildren().remove(j);
                    }
                    ++j;
                }
            }
            sdFolder.getChildren().removeAll(this.removedResources);
            boolean bl = doRefresh = initialSize != sdFolder.getChildren().size();
        }
        if (!this.addedResources.isEmpty()) {
            sdFolder.getChildren().addAll(this.addedResources);
            if (!doRefresh) {
                this.addToTree((Object)sdFolder, this.addedResources.toArray());
            }
        }
        if (!this.changedResources.isEmpty() && !doRefresh) {
            this.refreshTree(this.changedResources.toArray());
        }
        if (doRefresh) {
            this.refreshTree(sdFolder);
        }
        this.addedResources.clear();
        this.addedResources = null;
        this.removedResources.clear();
        this.removedResources = null;
        this.changedResources.clear();
        this.changedResources = null;
    }

    public boolean add(IResource parent, IResource[] affectedResources) {
        int i = 0;
        int maxi = affectedResources.length;
        while (i < maxi) {
            if (("trcdbxmi".equals(affectedResources[i].getFileExtension()) || "symptom".equals(affectedResources[i].getFileExtension())) && this.navigator.getContentProvider().getSDFolder().getChildren().add(affectedResources[i])) {
                this.addedResources.add(affectedResources[i]);
            }
            ++i;
        }
        return false;
    }

    public boolean remove(IResource parent, IResource[] affectedResources) {
        int i = 0;
        int maxi = affectedResources.length;
        while (i < maxi) {
            if (affectedResources[i].getType() != 1) {
                this.removedResources.add(affectedResources[i]);
            } else if ("trcdbxmi".equals(affectedResources[i].getFileExtension()) || "symptom".equals(affectedResources[i].getFileExtension())) {
                this.removedResources.add(affectedResources[i]);
            }
            ++i;
        }
        return false;
    }

    public boolean replaced(IResource affectedResource) {
        return false;
    }

    public boolean updateChildrenType(IResource affectedResource) {
        return false;
    }

    public boolean updateContent(IResource parent, IResource affectedResource) {
        return false;
    }

    public boolean updateProperties(IResource affectedResource) {
        if ("trcdbxmi".equals(affectedResource.getFileExtension()) || "symptom".equals(affectedResource.getFileExtension())) {
            this.changedResources.add(affectedResource);
        }
        return false;
    }

    protected void addToTree(final Object parent, final Object element) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LogNavigatorSynchronizer.this.getNavigator().getTreeViewer().add(parent, element);
            }
        });
    }

    protected void addToTree(final Object parent, final Object[] elements) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                LogNavigator navigator = LogNavigatorSynchronizer.this.getNavigator();
                if (navigator != null) {
                    navigator.getTreeViewer().add(parent, elements);
                }
            }
        });
    }

    protected void removeFromTree(final Object element) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (LogNavigatorSynchronizer.this.navigator != null && LogNavigatorSynchronizer.this.navigator.getTreeViewer() != null && !LogNavigatorSynchronizer.this.navigator.getTreeViewer().getControl().isDisposed()) {
                    LogNavigatorSynchronizer.this.navigator.getTreeViewer().remove(element);
                }
            }
        });
    }

    protected void removeFromTree(final Object[] elements) {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (LogNavigatorSynchronizer.this.navigator != null && LogNavigatorSynchronizer.this.navigator.getTreeViewer() != null && !LogNavigatorSynchronizer.this.navigator.getTreeViewer().getControl().isDisposed()) {
                    LogNavigatorSynchronizer.this.navigator.getTreeViewer().remove(elements);
                }
            }
        });
    }

    protected void refreshTree(final Object element) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (LogNavigatorSynchronizer.this.navigator != null && LogNavigatorSynchronizer.this.navigator.getTreeViewer() != null && !LogNavigatorSynchronizer.this.navigator.getTreeViewer().getControl().isDisposed()) {
                    LogNavigatorSynchronizer.this.navigator.getTreeViewer().refresh(element, true);
                }
            }
        });
    }

    protected void refreshTree(final Object[] elements) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                int i = 0;
                int maxi = elements.length;
                while (i < maxi) {
                    LogNavigatorSynchronizer.this.getNavigator().getTreeViewer().refresh(elements[i], true);
                    ++i;
                }
            }
        });
    }

    protected LogNavigator getNavigator() {
        return this.navigator;
    }

    public void refreshContent(IResource affectedResource) {
    }
}

