/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.preferences;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.util.ContextIds;
import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.log.ui.internal.util.RecordChangeEvent;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class LogAnalyzerFormatPrefPage {
    private Combo dateFormatCombo;
    private Combo timeFormatCombo;
    private IPreferenceStore _preferenceStore;

    public LogAnalyzerFormatPrefPage(IPreferenceStore preferenceStore) {
        this._preferenceStore = preferenceStore;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label description = new Label(composite, 0);
        description.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_DESCRIPTION"));
        Composite comboComposite = this.createComboGroup(composite);
        this.createFormatComboBoxes(comboComposite);
        return composite;
    }

    private Composite createComboGroup(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        Composite comboComposite = new Composite(composite, 16384);
        comboComposite.setLayout((Layout)layout);
        comboComposite.setLayoutData((Object)GridUtil.createHorizontalFill());
        return comboComposite;
    }

    private void createFormatComboBoxes(Composite composite) {
        Label dateFormatLabel = new Label(composite, 0);
        dateFormatLabel.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_DATE_FORMAT_LABEL"));
        this.dateFormatCombo = new Combo(composite, 8);
        this.dateFormatCombo.setItems(this.createDateFormatList());
        this.dateFormatCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label timeFormatLabel = new Label(composite, 0);
        timeFormatLabel.setText(LogUIPlugin.getResourceString("LOG_ANALYZER_FORMAT_PREF_PAGE_TIME_FORMAT_LABEL"));
        this.timeFormatCombo = new Combo(composite, 8);
        this.timeFormatCombo.setItems(this.createTimeFormatList());
        this.timeFormatCombo.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.selectFormatComboBoxes(this._preferenceStore.getString("LogAnalyzer.DateFormat"), this._preferenceStore.getString("LogAnalyzer.TimeFormat"));
        WorkbenchHelp.setHelp((Control)this.dateFormatCombo, (String)ContextIds.ACTLOG_PREF_FORMAT_DATE);
        WorkbenchHelp.setHelp((Control)this.timeFormatCombo, (String)ContextIds.ACTLOG_PREF_FORMAT_TIME);
    }

    private String[] createDateFormatList() {
        Date currentDate = new Date(System.currentTimeMillis());
        String[] dateFormatList = new String[]{LogUIConstants.DATE_FORMAT_FULL + " (" + DateFormat.getDateInstance(0).format(currentDate) + ")", LogUIConstants.DATE_FORMAT_LONG + " (" + DateFormat.getDateInstance(1).format(currentDate) + ")", LogUIConstants.DATE_FORMAT_MEDIUM + " (" + DateFormat.getDateInstance(2).format(currentDate) + ")", LogUIConstants.DATE_FORMAT_SHORT + " (" + DateFormat.getDateInstance(3).format(currentDate) + ")"};
        return dateFormatList;
    }

    private String[] createTimeFormatList() {
        Date currentDate = new Date(System.currentTimeMillis());
        String[] timeFormatList = new String[]{LogUIConstants.TIME_FORMAT_FULL + " (" + DateFormat.getTimeInstance(0).format(currentDate) + ")", LogUIConstants.TIME_FORMAT_LONG + " (" + DateFormat.getTimeInstance(1).format(currentDate) + ")", LogUIConstants.TIME_FORMAT_MEDIUM + " (" + DateFormat.getTimeInstance(2).format(currentDate) + ")", LogUIConstants.TIME_FORMAT_SHORT + " (" + DateFormat.getTimeInstance(3).format(currentDate) + ")"};
        return timeFormatList;
    }

    private void selectFormatComboBoxes(String dateFormat, String timeFormat) {
        int index = -1;
        int i = 0;
        while (i < LogUIConstants.DATE_FORMAT_LIST.length) {
            if (dateFormat.equals(LogUIConstants.DATE_FORMAT_LIST[i])) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > -1) {
            this.dateFormatCombo.select(index);
        } else {
            this.dateFormatCombo.select(0);
        }
        index = -1;
        int i2 = 0;
        while (i2 < LogUIConstants.TIME_FORMAT_LIST.length) {
            if (timeFormat.equals(LogUIConstants.TIME_FORMAT_LIST[i2])) {
                index = i2;
                break;
            }
            ++i2;
        }
        if (index > -1) {
            this.timeFormatCombo.select(index);
        } else {
            this.timeFormatCombo.select(0);
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.selectFormatComboBoxes(this._preferenceStore.getDefaultString("LogAnalyzer.DateFormat"), this._preferenceStore.getDefaultString("LogAnalyzer.TimeFormat"));
    }

    public boolean performOk() {
        String selectedDateFormat = LogUIConstants.DATE_FORMAT_LIST[this.dateFormatCombo.getSelectionIndex()];
        boolean dateFmtChanged = false;
        if (!this._preferenceStore.getString("LogAnalyzer.DateFormat").equals(selectedDateFormat)) {
            dateFmtChanged = true;
        }
        this._preferenceStore.setValue("LogAnalyzer.DateFormat", selectedDateFormat);
        String selectedTimeFormat = LogUIConstants.TIME_FORMAT_LIST[this.timeFormatCombo.getSelectionIndex()];
        boolean timeFmtChanged = false;
        if (!this._preferenceStore.getString("LogAnalyzer.TimeFormat").equals(selectedTimeFormat)) {
            timeFmtChanged = true;
        }
        this._preferenceStore.setValue("LogAnalyzer.TimeFormat", selectedTimeFormat);
        LogUIPlugin.getDefault().savePluginPreferences();
        if (dateFmtChanged || timeFmtChanged) {
            LogUIPlugin.getDefault().fireRecordChangeNotification(new RecordChangeEvent(3, this));
        }
        return true;
    }
}

